package com.tydic.dyc.oc.repository.po;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 标题:UocOrderStateChgLogPo
 * 说明:订单状态变更记录表
 * 时间:2022-02-23 20:57
 * 作者:罗有
 **/
@Data
public class UocOrderStateChgLogPo implements Serializable {
	private static final long serialVersionUID =  7570784852523312816L;

	@DocField(value = "id")
	private Long id;

	@DocField(value = "单据id")
	private Long objId;

	@DocField(value = "单据类型:1订单   2.销售单   3.执行单   4.发货单   5.收货单   6.售后服务单  7.支付单     99.其他")
	private Integer objType;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "修改前状态")
	private String oldState;

	@DocField(value = "修改后状态")
	private String newState;

	@DocField(value = "变更时间")
	private Date chgTime;

	@DocField(value = "变更时间 开始")
	private Date chgTimeStart;

	@DocField(value = "变更时间 结束")
	private Date chgTimeEnd;

	@DocField(value = "变更工号")
	private String operId;

	@DocField(value = "状态变更原因")
	private Integer chgReson;

	@DocField(value = "状态变更说明")
	private String chgDesc;

	@DocField(value = "排序")
	private String orderBy;

}
