package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocApplyOrderMapPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocApplyOrderMapMapper
 * 说明:申请单扩展
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocApplyOrderMapMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocApplyOrderMapPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocApplyOrderMapPo uocApplyOrderMapPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocApplyOrderMapPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocApplyOrderMapPo uocApplyOrderMapPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocApplyOrderMapPo set, @Param("where") UocApplyOrderMapPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocApplyOrderMapPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocApplyOrderMapPo uocApplyOrderMapPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocApplyOrderMapPo 参数对象
	 * @return UocApplyOrderMapPo 结果对象
	 */
	UocApplyOrderMapPo getModelBy(UocApplyOrderMapPo uocApplyOrderMapPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocApplyOrderMapPo 参数对象
	 * @return List<UocApplyOrderMapPo> 结果对象
	 */
	List<UocApplyOrderMapPo> getList(UocApplyOrderMapPo uocApplyOrderMapPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocApplyOrderMapPo 参数对象
	 * @param page 分页参数
	 * @return List<UocApplyOrderMapPo> 结果对象
	 */
	List<UocApplyOrderMapPo> getListPage(UocApplyOrderMapPo uocApplyOrderMapPo, Page<UocApplyOrderMapPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocApplyOrderMapPo> list);

}
