package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocConfTabOrdStatePo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocConfTabOrdStateMapper
 * 说明:页面每个sheet页对应的实际订单状态映射规则配置
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocConfTabOrdStateMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocConfTabOrdStatePo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocConfTabOrdStatePo uocConfTabOrdStatePo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocConfTabOrdStatePo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocConfTabOrdStatePo uocConfTabOrdStatePo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocConfTabOrdStatePo set, @Param("where") UocConfTabOrdStatePo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocConfTabOrdStatePo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocConfTabOrdStatePo uocConfTabOrdStatePo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocConfTabOrdStatePo 参数对象
	 * @return UocConfTabOrdStatePo 结果对象
	 */
	UocConfTabOrdStatePo getModelBy(UocConfTabOrdStatePo uocConfTabOrdStatePo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocConfTabOrdStatePo 参数对象
	 * @return List<UocConfTabOrdStatePo> 结果对象
	 */
	List<UocConfTabOrdStatePo> getList(UocConfTabOrdStatePo uocConfTabOrdStatePo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocConfTabOrdStatePo 参数对象
	 * @param page 分页参数
	 * @return List<UocConfTabOrdStatePo> 结果对象
	 */
	List<UocConfTabOrdStatePo> getListPage(UocConfTabOrdStatePo uocConfTabOrdStatePo, Page<UocConfTabOrdStatePo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocConfTabOrdStatePo> list);

}
