package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocShipOrderMapPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocShipOrderMapMapper
 * 说明:发货单扩展
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocShipOrderMapMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocShipOrderMapPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocShipOrderMapPo uocShipOrderMapPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocShipOrderMapPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocShipOrderMapPo uocShipOrderMapPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocShipOrderMapPo set, @Param("where") UocShipOrderMapPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocShipOrderMapPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocShipOrderMapPo uocShipOrderMapPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocShipOrderMapPo 参数对象
	 * @return UocShipOrderMapPo 结果对象
	 */
	UocShipOrderMapPo getModelBy(UocShipOrderMapPo uocShipOrderMapPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocShipOrderMapPo 参数对象
	 * @return List<UocShipOrderMapPo> 结果对象
	 */
	List<UocShipOrderMapPo> getList(UocShipOrderMapPo uocShipOrderMapPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocShipOrderMapPo 参数对象
	 * @param page 分页参数
	 * @return List<UocShipOrderMapPo> 结果对象
	 */
	List<UocShipOrderMapPo> getListPage(UocShipOrderMapPo uocShipOrderMapPo, Page<UocShipOrderMapPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocShipOrderMapPo> list);

	void updateBatchValue(@Param("list") List<UocShipOrderMapPo> uocShipOrderMapPoList, @Param("uocShipOrderMapPo") UocShipOrderMapPo uocShipOrderMapPo);

	void updateInvalid(UocShipOrderMapPo uocShipOrderMapPo);
    
    
    int updateByShipOrderId(UocShipOrderMapPo uocShipOrderMapPo);
}
