/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.common.qrybo.UocConfSupplierBo;
import com.tydic.dyc.oc.model.common.qrybo.UocQryMateriaOrderNoBo;
import com.tydic.dyc.oc.model.common.qrybo.UocQrySaleOrderStageBO;
import com.tydic.dyc.oc.model.common.sub.UocCfcParamConfigDo;
import com.tydic.dyc.oc.model.common.sub.UocCfcParamConfigItemDo;
import com.tydic.dyc.oc.model.common.sub.UocConfSupplierDO;
import com.tydic.dyc.oc.model.common.sub.UocFile;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderBusiOperRecord;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.order.sub.UocOrderStateChgLog;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.order.sub.UocTodo;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.repository.dao.CfcParamConfigItemMapper;
import com.tydic.dyc.oc.repository.dao.CfcParamConfigMapper;
import com.tydic.dyc.oc.repository.dao.ConfSupplierMapper;
import com.tydic.dyc.oc.repository.dao.UocConfSupplierMapper;
import com.tydic.dyc.oc.repository.dao.UocConfTabOrdStateMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderAccessoryMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderBusiOperRecordMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderMsgPoolMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderProcInstMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderQueryIndexMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderStateChgLogMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderTaskDealMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderTaskInstLogMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderTaskInstMapper;
import com.tydic.dyc.oc.repository.dao.UocSaleItemMapMapper;
import com.tydic.dyc.oc.repository.dao.UocSaleOrderStateToStageConfigMapper;
import com.tydic.dyc.oc.repository.dao.UocTodoMapper;
import com.tydic.dyc.oc.repository.po.CfcParamConfigItemPo;
import com.tydic.dyc.oc.repository.po.CfcParamConfigPo;
import com.tydic.dyc.oc.repository.po.UocConfSupplierPo;
import com.tydic.dyc.oc.repository.po.UocOrderAccessoryPo;
import com.tydic.dyc.oc.repository.po.UocOrderBusiOperRecordPo;
import com.tydic.dyc.oc.repository.po.UocOrderProcInstPo;
import com.tydic.dyc.oc.repository.po.UocOrderQueryIndexPo;
import com.tydic.dyc.oc.repository.po.UocOrderStateChgLogPo;
import com.tydic.dyc.oc.repository.po.UocOrderTaskDealPo;
import com.tydic.dyc.oc.repository.po.UocOrderTaskInstLogPo;
import com.tydic.dyc.oc.repository.po.UocOrderTaskInstPo;
import com.tydic.dyc.oc.repository.po.UocTodoPo;
import com.tydic.dyc.oc.utils.UocRu;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.CfcRedisSerialService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocCommonRepositoryImpl
implements UocCommonRepository {
    @Autowired
    private UocOrderAccessoryMapper uocOrderAccessoryMapper;
    @Autowired
    private UocOrderTaskInstMapper uocOrderTaskInstMapper;
    @Autowired
    private UocOrderProcInstMapper uocOrderProcInstMapper;
    @Autowired
    private UocOrderTaskDealMapper uocOrderTaskDealMapper;
    @Autowired
    private UocOrderStateChgLogMapper uocOrderStateChgLogMapper;
    @Autowired
    private UocOrderBusiOperRecordMapper uocOrderBusiOperRecordMapper;
    @Autowired
    private UocConfTabOrdStateMapper uocConfTabOrdStateMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private UocConfSupplierMapper uocConfSupplierMapper;
    @Autowired
    private ConfSupplierMapper confSupplierMapper;
    @Autowired
    private UocOrderMsgPoolMapper uocOrderMsgPoolMapper;
    @Autowired
    private UocOrderQueryIndexMapper uocOrderQueryIndexMapper;
    @Autowired
    private UocOrderTaskInstLogMapper uocOrderTaskInstLogMapper;
    @Autowired
    private CfcRedisSerialService cfcRedisSerialService;
    @Autowired
    private UocTodoMapper uocTodoMapper;
    @Autowired
    private CfcParamConfigMapper cfcParamConfigMapper;
    @Autowired
    private CfcParamConfigItemMapper cfcParamConfigItemMapper;
    @Autowired
    private UocSaleItemMapMapper uocSaleItemMapMapper;
    @Autowired
    private UocSaleOrderStateToStageConfigMapper uocSaleOrderStateToStageConfigMapper;
    @Autowired
    private FileClient fileClient;
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";

    public void addBatchOrderAccessory(List<UocOrderAccessory> uocOrderAccessoryList) {
        if (!CollectionUtils.isEmpty(uocOrderAccessoryList)) {
            this.uocOrderAccessoryMapper.insertBatch(UocRu.jsl(uocOrderAccessoryList, UocOrderAccessoryPo.class));
        }
    }

    public void updateToFinished(List<UocOrderTaskInst> uocOrderTaskInstList) {
        for (UocOrderTaskInst uocOrderTaskInst : uocOrderTaskInstList) {
            UocOrderTaskInstPo updateSetPo = new UocOrderTaskInstPo();
            updateSetPo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.FINISHED);
            updateSetPo.setFinishTime(new Date());
            updateSetPo.setDealOperId(uocOrderTaskInst.getDealOperId());
            updateSetPo.setDealOperName(uocOrderTaskInst.getDealOperName());
            updateSetPo.setDealResult(uocOrderTaskInst.getDealResult());
            updateSetPo.setDealRemark(uocOrderTaskInst.getDealRemark());
            UocOrderTaskInstPo updateWherePo = new UocOrderTaskInstPo();
            updateWherePo.setOrderId(uocOrderTaskInst.getOrderId());
            updateWherePo.setTaskInstId(uocOrderTaskInst.getTaskInstId());
            this.uocOrderTaskInstMapper.updateBy(updateSetPo, updateWherePo);
        }
    }

    public void saveProcTaskInst(List<UocOrderTaskInst> saveTaskList) {
        if (ObjectUtil.isNotEmpty(saveTaskList)) {
            this.uocOrderTaskInstMapper.insertBatch(UocRu.jsl(saveTaskList, UocOrderTaskInstPo.class));
        }
    }

    public UocOrderProcInst createProInst(UocOrderProcInst inst) {
        this.uocOrderProcInstMapper.insert((UocOrderProcInstPo)UocRu.js((Object)inst, UocOrderProcInstPo.class));
        return inst;
    }

    public List<UocOrderProcInst> qryProcInsList(UocOrderProcInst inst) {
        return UocRu.jsl(this.uocOrderProcInstMapper.getList((UocOrderProcInstPo)UocRu.js((Object)inst, UocOrderProcInstPo.class)), UocOrderProcInst.class);
    }

    public void saveOrderTaskDealList(List<UocOrderTaskDeal> dealList) {
        if (ObjectUtil.isNotEmpty(dealList)) {
            this.uocOrderTaskDealMapper.insertBatch(UocRu.jsl(dealList, UocOrderTaskDealPo.class));
        }
    }

    public UocOrderStateChgLog createOrderStateChangeLog(UocOrderStateChgLog uocOrderStateChgLog) {
        if (ObjectUtil.isNotEmpty((Object)uocOrderStateChgLog)) {
            this.uocOrderStateChgLogMapper.insert((UocOrderStateChgLogPo)UocRu.js((Object)uocOrderStateChgLog, UocOrderStateChgLogPo.class));
        }
        return uocOrderStateChgLog;
    }

    public List<UocOrderTaskInst> qryTaskInstList(UocOrderTaskInst taskInst) {
        if (ObjectUtil.isNotEmpty((Object)taskInst)) {
            return UocRu.jsl(this.uocOrderTaskInstMapper.getList((UocOrderTaskInstPo)UocRu.js((Object)taskInst, UocOrderTaskInstPo.class)), UocOrderTaskInst.class);
        }
        return new ArrayList<UocOrderTaskInst>();
    }

    public UocOrderProcInst updateProInst(UocOrderProcInst inst) {
        UocOrderProcInstPo set = (UocOrderProcInstPo)UocRu.js((Object)inst, UocOrderProcInstPo.class);
        UocOrderProcInstPo where = new UocOrderProcInstPo();
        where.setOrderId(inst.getOrderId());
        where.setObjId(inst.getObjId());
        where.setObjType(inst.getObjType());
        where.setProcInstId(inst.getProcInstId());
        this.uocOrderProcInstMapper.updateBy(set, where);
        return inst;
    }

    public void saveOperRecord(List<UocOrderBusiOperRecord> recordList) {
        List recordPoList = UocRu.jsl(recordList, UocOrderBusiOperRecordPo.class);
        this.uocOrderBusiOperRecordMapper.insertBatch(recordPoList);
    }

    public String getOrderNoSingle(String code) {
        CfcEncodedSerialGetServiceReqBO getBo = new CfcEncodedSerialGetServiceReqBO();
        getBo.setCenter("UOC");
        getBo.setEncodedRuleCode(code);
        getBo.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO encodedSerial = this.cfcRedisSerialService.getSerial(getBo);
        if (CollectionUtils.isEmpty((Collection)encodedSerial.getSerialNoList()) || StringUtils.isBlank((CharSequence)((CharSequence)encodedSerial.getSerialNoList().get(0)))) {
            throw new BaseBusinessException("101006", "\u83b7\u53d6\u5355\u636e\u7f16\u53f7\u4e3a\u7a7a");
        }
        return (String)encodedSerial.getSerialNoList().get(0);
    }

    public void updateTaskInst(UocOrderTaskInst inst) {
        UocOrderTaskInstPo set = (UocOrderTaskInstPo)UocRu.js((Object)inst, UocOrderTaskInstPo.class);
        UocOrderTaskInstPo where = new UocOrderTaskInstPo();
        where.setTaskInstId(inst.getTaskInstId());
        where.setOrderId(inst.getOrderId());
        where.setObjId(inst.getObjId());
        where.setObjType(inst.getObjType());
        where.setId(inst.getId());
        where.setProcState(inst.getProcState());
        this.uocOrderTaskInstMapper.updateBy(set, where);
    }

    public UocFile uploadFile(UocFile uocFile) {
        String fileUrl;
        String path = this.fileClient.uploadFileByInputStream(uocFile.getPath(), uocFile.getFilename(), uocFile.getInputStream());
        if (FILE_TYPE_OSS.equals(uocFile.getFileType())) {
            fileUrl = path;
        } else if (FILE_TYPE_FASTDFS.equals(uocFile.getFileType())) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            fileUrl = "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        UocFile uocF = new UocFile();
        uocF.setUrl(fileUrl);
        return uocF;
    }

    public int saveOrderQueryIndex(UocOrderQueryIndex index) {
        return this.uocOrderQueryIndexMapper.insert((UocOrderQueryIndexPo)JUtil.js((Object)index, UocOrderQueryIndexPo.class));
    }

    public void deleteTaskInstByStepIdAndFinshTag(UocOrderTaskInst taskInst) {
        UocOrderTaskInstPo where = new UocOrderTaskInstPo();
        where.setOrderId(taskInst.getOrderId());
        where.setProcState(taskInst.getProcState());
        this.uocOrderTaskInstMapper.deleteTaskInstByStepIdAndFinshTag(where);
    }

    public void saveProcTaskInstLog(List<UocOrderTaskInst> saveTaskList) {
        List uocOrderTaskInstLogPos = UocRu.jsl(saveTaskList, UocOrderTaskInstLogPo.class);
        if (!CollectionUtils.isEmpty((Collection)uocOrderTaskInstLogPos)) {
            this.uocOrderTaskInstLogMapper.insertBatch(uocOrderTaskInstLogPos);
        }
    }

    public void deleteProcTaskInstByIds(UocOrderTaskInst taskInst) {
        UocOrderTaskInstPo where = new UocOrderTaskInstPo();
        where.setOrderId(taskInst.getOrderId());
        where.setIds(taskInst.getIds());
        this.uocOrderTaskInstMapper.deleteProcTaskInstByIds(where);
    }

    public void updateTaskDeal(UocOrderTaskDeal taskDeal) {
        UocOrderTaskDealPo set = new UocOrderTaskDealPo();
        set.setDealId(taskDeal.getDealId());
        set.setDealName(taskDeal.getDealName());
        UocOrderTaskDealPo where = new UocOrderTaskDealPo();
        where.setTaskInstId(taskDeal.getTaskInstId());
        this.uocOrderTaskDealMapper.updateBy(set, where);
    }

    public int saveTodoInfo(UocTodo uocTodo) {
        return this.uocTodoMapper.insert((UocTodoPo)UocRu.js((Object)uocTodo, UocTodoPo.class));
    }

    public int updateTodoById(UocTodo uocTodo) {
        return this.uocTodoMapper.updateById((UocTodoPo)UocRu.js((Object)uocTodo, UocTodoPo.class));
    }

    public UocTodo getTodoInfo(UocTodo uocTodo) {
        UocTodoPo modelBy = this.uocTodoMapper.getModelBy((UocTodoPo)UocRu.js((Object)uocTodo, UocTodoPo.class));
        return ObjectUtil.isNotEmpty((Object)modelBy) ? (UocTodo)UocRu.js((Object)modelBy, UocTodo.class) : new UocTodo();
    }

    public List<UocTodo> getTodoListInfo(UocTodo uocTodo) {
        List<UocTodoPo> todoPoList = this.uocTodoMapper.getList((UocTodoPo)UocRu.js((Object)uocTodo, UocTodoPo.class));
        return CollectionUtils.isEmpty(todoPoList) ? new ArrayList() : UocRu.jsl(todoPoList, UocTodo.class);
    }

    public void insertBatchTodo(List<UocTodo> list) {
        List recordPoList = UocRu.jsl(list, UocTodoPo.class);
        this.uocTodoMapper.insertBatch(recordPoList);
    }

    public UocCfcParamConfigDo qryCfcParamByCode(String paramCode) {
        UocCfcParamConfigDo retDo = new UocCfcParamConfigDo();
        CfcParamConfigPo qryPo = new CfcParamConfigPo();
        qryPo.setParamConfigCode(paramCode);
        CfcParamConfigPo qryRspPo = this.cfcParamConfigMapper.getModelBy(qryPo);
        if (ObjectUtil.isNotEmpty((Object)qryRspPo)) {
            BeanUtils.copyProperties((Object)qryRspPo, (Object)retDo);
            CfcParamConfigItemPo qryItemPo = new CfcParamConfigItemPo();
            qryItemPo.setParamConfigCode(paramCode);
            List<CfcParamConfigItemPo> itemListPo = this.cfcParamConfigItemMapper.getList(qryItemPo);
            if (ObjectUtil.isNotEmpty(itemListPo)) {
                retDo.setItemList(JUtil.jsl(itemListPo, UocCfcParamConfigItemDo.class));
            }
        }
        return retDo;
    }

    public UocCfcParamConfigItemDo updateCfcItemValue(UocCfcParamConfigItemDo reqDo) {
        CfcParamConfigItemPo where = new CfcParamConfigItemPo();
        CfcParamConfigItemPo set = new CfcParamConfigItemPo();
        where.setItemId(reqDo.getItemId());
        set.setItemValue(reqDo.getItemValue());
        set.setCreateTime(reqDo.getCreateTime());
        set.setCreateId(reqDo.getCreateId());
        set.setCreateName(reqDo.getCreateName());
        this.cfcParamConfigItemMapper.updateBy(set, where);
        return reqDo;
    }

    public UocQryMateriaOrderNoBo qryMateriaBySkuIdAndUserId(UocQryMateriaOrderNoBo qryBo) {
        return this.uocSaleItemMapMapper.qryMateriaBySkuIdAndUserId(qryBo);
    }

    public UocQrySaleOrderStageBO qrySaleOrderStageByOrderStateAndprocState(UocQrySaleOrderStageBO qryBo) {
        return this.uocSaleOrderStateToStageConfigMapper.getOrderStageByOrderStateAndProcState(qryBo);
    }

    public UocConfSupplierBo qryConfSupplier(String goodsSupplierNo) {
        UocConfSupplierPo uocConfSupplierPo = new UocConfSupplierPo();
        uocConfSupplierPo.setSupNo(goodsSupplierNo);
        uocConfSupplierPo = this.uocConfSupplierMapper.getModelBy(uocConfSupplierPo);
        return ObjectUtil.isNotEmpty((Object)uocConfSupplierPo) ? (UocConfSupplierBo)UocRu.js((Object)uocConfSupplierPo, UocConfSupplierBo.class) : new UocConfSupplierBo();
    }

    public List<UocConfSupplierDO> qryConfSupplierList(UocConfSupplierDO uocConfSupplierDO) {
        UocConfSupplierPo qrySupConfPo = new UocConfSupplierPo();
        qrySupConfPo.setSupplierNos(uocConfSupplierDO.getSupplierNos());
        qrySupConfPo.setLimitStatus(uocConfSupplierDO.getLimitStatus());
        qrySupConfPo.setSupNo(uocConfSupplierDO.getSupNo());
        qrySupConfPo.setBusinessTypeCode(uocConfSupplierDO.getBusinessTypeCode());
        List<UocConfSupplierPo> confSupplierList = this.uocConfSupplierMapper.getList(qrySupConfPo);
        return ObjectUtil.isNotEmpty(confSupplierList) ? UocRu.jsl(confSupplierList, UocConfSupplierDO.class) : new ArrayList();
    }
}

