package com.tydic.dyc.oc.repository.po;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocOrderProcInstPo
 * 说明:订单流程实例
 * 时间:2022-04-11 15:05
 * 作者:罗有
 **/
@Data
public class UocOrderProcInstPo implements Serializable {
	private static final long serialVersionUID = -5019017530920050363L;

	@DocField(value = "id")
	private Long id;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "流程实例id")
	private String procInstId;

	@DocField(value = "流程key定义")
	private String procDefId;

	@DocField(value = "单据id")
	private Long objId;

	@DocField(value = "单据类型:1订单   2.销售单   3.执行单   4.发货单   5.收货单   6.售后服务单  7.支付单  8验收单，9审批单   99.其他")
	private Integer objType;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建时间 开始")
	private Date createTimeStart;

	@DocField(value = "创建时间 结束")
	private Date createTimeEnd;

	@DocField(value = "完结标志0未完结1已完结")
	private Integer finishTag;

	@DocField(value = "完成时间")
	private Date finishTime;

	@DocField(value = "完成时间 开始")
	private Date finishTimeStart;

	@DocField(value = "完成时间 结束")
	private Date finishTimeEnd;

	@DocField(value = "删除标志1已删除")
	private Integer delTag;

	@DocField(value = "排序")
	private String orderBy;

	@DocField(value = "排除的对象类型")
	private List<Integer> objTypeNoInList;

	@DocField(value = "单据idList")
	private List<Long> objIdList;
}
