package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocObjNoConstants;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.common.qrybo.UocConfSupplierBo;
import com.tydic.dyc.oc.model.common.qrybo.UocQryMateriaOrderNoBo;
import com.tydic.dyc.oc.model.common.qrybo.UocQrySaleOrderStageBO;
import com.tydic.dyc.oc.model.common.sub.UocCfcParamConfigDo;
import com.tydic.dyc.oc.model.common.sub.UocCfcParamConfigItemDo;
import com.tydic.dyc.oc.model.common.sub.UocConfSupplierDO;
import com.tydic.dyc.oc.model.common.sub.UocFile;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.repository.dao.*;
import com.tydic.dyc.oc.repository.po.*;
import com.tydic.dyc.oc.utils.UocRu;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.CfcRedisSerialService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocCommonRepositoryImpl
 * 说明:通用
 * 时间:2022/2/25 19:38
 * 作者:罗有
 */

@Service
public class UocCommonRepositoryImpl implements UocCommonRepository {
    @Autowired
    private UocOrderAccessoryMapper uocOrderAccessoryMapper;
    @Autowired
    private UocOrderTaskInstMapper uocOrderTaskInstMapper;

    @Autowired
    private UocOrderProcInstMapper uocOrderProcInstMapper;

    @Autowired
    private UocOrderTaskDealMapper uocOrderTaskDealMapper;

    @Autowired
    private UocOrderStateChgLogMapper uocOrderStateChgLogMapper;

    @Autowired
    private UocOrderBusiOperRecordMapper uocOrderBusiOperRecordMapper;

    @Autowired
    private UocConfTabOrdStateMapper uocConfTabOrdStateMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;

    @Autowired
    private UocConfSupplierMapper uocConfSupplierMapper;

    @Autowired
    private ConfSupplierMapper confSupplierMapper;

    @Autowired
    private UocOrderMsgPoolMapper uocOrderMsgPoolMapper;

    @Autowired
    private UocOrderQueryIndexMapper uocOrderQueryIndexMapper;

    @Autowired
    private UocOrderTaskInstLogMapper uocOrderTaskInstLogMapper;

    @Autowired
    private CfcRedisSerialService cfcRedisSerialService;
    @Autowired
    private UocTodoMapper uocTodoMapper;

    @Autowired
    private CfcParamConfigMapper cfcParamConfigMapper;

    @Autowired
    private CfcParamConfigItemMapper cfcParamConfigItemMapper;

    @Autowired
    private UocSaleItemMapMapper uocSaleItemMapMapper;

    @Autowired
    private UocSaleOrderStateToStageConfigMapper uocSaleOrderStateToStageConfigMapper;

    
    
    @Value("${obs.fileUrl:}")
    private String obsFileUrl;
    
    
    @Override
    public void addBatchOrderAccessory(List<UocOrderAccessory> uocOrderAccessoryList) {
        if (!CollectionUtils.isEmpty(uocOrderAccessoryList)) {
            uocOrderAccessoryMapper.insertBatch(UocRu.jsl(uocOrderAccessoryList, UocOrderAccessoryPo.class));
        }
    }

    @Override
    public void updateToFinished(List<UocOrderTaskInst> uocOrderTaskInstList) {
        for (UocOrderTaskInst uocOrderTaskInst : uocOrderTaskInstList) {
            UocOrderTaskInstPo updateSetPo = new UocOrderTaskInstPo();
            updateSetPo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.FINISHED);
            updateSetPo.setFinishTime(new Date());
            updateSetPo.setDealOperId(uocOrderTaskInst.getDealOperId());
            updateSetPo.setDealOperName(uocOrderTaskInst.getDealOperName());
            updateSetPo.setDealResult(uocOrderTaskInst.getDealResult());
            updateSetPo.setDealRemark(uocOrderTaskInst.getDealRemark());
            UocOrderTaskInstPo updateWherePo = new UocOrderTaskInstPo();
            updateWherePo.setOrderId(uocOrderTaskInst.getOrderId());
            updateWherePo.setTaskInstId(uocOrderTaskInst.getTaskInstId());

            uocOrderTaskInstMapper.updateBy(updateSetPo, updateWherePo);
        }

    }

    @Override
    public void saveProcTaskInst(List<UocOrderTaskInst> saveTaskList) {
        if (ObjectUtil.isNotEmpty(saveTaskList)) {
            uocOrderTaskInstMapper.insertBatch(UocRu.jsl(saveTaskList, UocOrderTaskInstPo.class));
        }
    }

    @Override
    public UocOrderProcInst createProInst(UocOrderProcInst inst) {
        uocOrderProcInstMapper.insert(UocRu.js(inst, UocOrderProcInstPo.class));
        return inst;
    }

    @Override
    public List<UocOrderProcInst> qryProcInsList(UocOrderProcInst inst) {
        return UocRu.jsl(uocOrderProcInstMapper.getList(UocRu.js(inst, UocOrderProcInstPo.class)), UocOrderProcInst.class);
    }

    @Override
    public void saveOrderTaskDealList(List<UocOrderTaskDeal> dealList) {
        if (ObjectUtil.isNotEmpty(dealList)) {
            uocOrderTaskDealMapper.insertBatch(UocRu.jsl(dealList, UocOrderTaskDealPo.class));
        }
    }

    @Override
    public UocOrderStateChgLog createOrderStateChangeLog(UocOrderStateChgLog uocOrderStateChgLog) {
        if (ObjectUtil.isNotEmpty(uocOrderStateChgLog)) {
            uocOrderStateChgLogMapper.insert(UocRu.js(uocOrderStateChgLog, UocOrderStateChgLogPo.class));
        }
        return uocOrderStateChgLog;
    }

    @Override
    public List<UocOrderTaskInst> qryTaskInstList(UocOrderTaskInst taskInst) {
        if (ObjectUtil.isNotEmpty(taskInst)) {
            return UocRu.jsl(uocOrderTaskInstMapper.getList(UocRu.js(taskInst, UocOrderTaskInstPo.class)), UocOrderTaskInst.class);
        } else {
            return new ArrayList<>();
        }
    }

    @Override
    public UocOrderProcInst updateProInst(UocOrderProcInst inst) {
        UocOrderProcInstPo set = UocRu.js(inst, UocOrderProcInstPo.class);
        UocOrderProcInstPo where = new UocOrderProcInstPo();
        where.setOrderId(inst.getOrderId());
        where.setObjId(inst.getObjId());
        where.setObjType(inst.getObjType());
        where.setProcInstId(inst.getProcInstId());
        uocOrderProcInstMapper.updateBy(set, where);
        return inst;
    }

    @Override
    public void saveOperRecord(List<UocOrderBusiOperRecord> recordList) {
        List<UocOrderBusiOperRecordPo> recordPoList = UocRu.jsl(recordList, UocOrderBusiOperRecordPo.class);
        uocOrderBusiOperRecordMapper.insertBatch(recordPoList);
    }
    @Override
    public String getOrderNoSingle(String code) {
       /* CfcEncodedSerialGetServiceReqBO getBo = new CfcEncodedSerialGetServiceReqBO();
        getBo.setCenter(UocObjNoConstants.UOC);
        getBo.setEncodedRuleCode(code);
        getBo.setOrgType(UocObjNoConstants.ORG_TYPE);
        CfcEncodedSerialGetServiceRspBO encodedSerial = encodedSerialGetService.getEncodedSerial(getBo);
        if (CollectionUtils.isEmpty(encodedSerial.getSerialNoList()) || StringUtils.isBlank(encodedSerial.getSerialNoList().get(0))) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_NUM_CHNG_APPLY_ERROR, "获取单据编号为空");
        }
        return encodedSerial.getSerialNoList().get(0);*/

        //redis版编号获取
        CfcEncodedSerialGetServiceReqBO getBo = new CfcEncodedSerialGetServiceReqBO();
        getBo.setCenter(UocObjNoConstants.UOC);
        getBo.setEncodedRuleCode(code);
        getBo.setOrgType(UocObjNoConstants.ORG_TYPE);
        CfcEncodedSerialGetServiceRspBO encodedSerial = cfcRedisSerialService.getSerial(getBo);
        if (CollectionUtils.isEmpty(encodedSerial.getSerialNoList()) || StringUtils.isBlank(encodedSerial.getSerialNoList().get(0))) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_NUM_CHNG_APPLY_ERROR, "获取单据编号为空");
        }
        return encodedSerial.getSerialNoList().get(0);
    }

    @Override
    public void updateTaskInst(UocOrderTaskInst inst) {
        UocOrderTaskInstPo set = UocRu.js(inst, UocOrderTaskInstPo.class);
        UocOrderTaskInstPo where = new UocOrderTaskInstPo();
        where.setTaskInstId(inst.getTaskInstId());
        where.setOrderId(inst.getOrderId());
        where.setObjId(inst.getObjId());
        where.setObjType(inst.getObjType());
        where.setId(inst.getId());
        where.setProcState(inst.getProcState());
        uocOrderTaskInstMapper.updateBy(set, where);
    }

    @Autowired
    private FileClient fileClient;
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    public static final String FILE_TYPE_OBS = "OBS";

    @Override
    public UocFile uploadFile(UocFile uocFile) {

        String path = fileClient.uploadFileByInputStream(uocFile.getPath(), uocFile.getFilename(), uocFile.getInputStream());
        String fileUrl;
        if (FILE_TYPE_OSS.equals(uocFile.getFileType())){
            fileUrl =  path;
        }else if (FILE_TYPE_FASTDFS.equals(uocFile.getFileType())) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo(path);
            fileUrl = "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        }else if (FILE_TYPE_OBS.equals(uocFile.getFileType())) {
            if(path.startsWith("http")){
                fileUrl = path;
            }else{
                fileUrl = obsFileUrl + path;
            }
        } else {
            throw new ZTBusinessException("暂不支持的文件服务器类型");
        }
        UocFile uocF = new UocFile();
        uocF.setUrl(fileUrl);
        return uocF;
    }

    @Override
    public int saveOrderQueryIndex(UocOrderQueryIndex index) {
        return uocOrderQueryIndexMapper.insert(JUtil.js(index, UocOrderQueryIndexPo.class));
    }

    @Override
    public void deleteTaskInstByStepIdAndFinshTag(UocOrderTaskInst taskInst) {
        UocOrderTaskInstPo where = new UocOrderTaskInstPo();
        where.setOrderId(taskInst.getOrderId());
        where.setProcState(taskInst.getProcState());
        uocOrderTaskInstMapper.deleteTaskInstByStepIdAndFinshTag(where);
    }

    @Override
    public void saveProcTaskInstLog(List<UocOrderTaskInst> saveTaskList) {
        List<UocOrderTaskInstLogPo> uocOrderTaskInstLogPos = UocRu.jsl(saveTaskList,UocOrderTaskInstLogPo.class) ;
        if(!CollectionUtils.isEmpty(uocOrderTaskInstLogPos)){
            uocOrderTaskInstLogMapper.insertBatch(uocOrderTaskInstLogPos);
        }
    }

    @Override
    public void deleteProcTaskInstByIds(UocOrderTaskInst taskInst) {
        UocOrderTaskInstPo where = new UocOrderTaskInstPo();
        where.setOrderId(taskInst.getOrderId());
        where.setIds(taskInst.getIds());
        uocOrderTaskInstMapper.deleteProcTaskInstByIds(where);
    }

    @Override
    public void updateTaskDeal(UocOrderTaskDeal taskDeal) {
        UocOrderTaskDealPo set =  new UocOrderTaskDealPo();
        set.setDealId(taskDeal.getDealId());
        set.setDealName(taskDeal.getDealName());
        UocOrderTaskDealPo where =  new UocOrderTaskDealPo();
        where.setTaskInstId(taskDeal.getTaskInstId());
        uocOrderTaskDealMapper.updateBy(set,where);
    }

    @Override
    public int saveTodoInfo(UocTodo uocTodo) {
        return uocTodoMapper.insert(UocRu.js(uocTodo, UocTodoPo.class));
    }

    @Override
    public int updateTodoById(UocTodo uocTodo) {
        return uocTodoMapper.updateById(UocRu.js(uocTodo, UocTodoPo.class));
    }

    @Override
    public UocTodo getTodoInfo(UocTodo uocTodo) {
        UocTodoPo modelBy = uocTodoMapper.getModelBy(UocRu.js(uocTodo, UocTodoPo.class));
        return ObjectUtil.isNotEmpty(modelBy) ? UocRu.js(modelBy, UocTodo.class) : new UocTodo();
    }

    @Override
    public List<UocTodo> getTodoListInfo(UocTodo uocTodo) {
        List<UocTodoPo> todoPoList = uocTodoMapper.getList(UocRu.js(uocTodo, UocTodoPo.class));
        return CollectionUtils.isEmpty(todoPoList) ? new ArrayList<>() : UocRu.jsl(todoPoList, UocTodo.class);
    }

    @Override
    public void insertBatchTodo(List<UocTodo> list) {
        List<UocTodoPo> recordPoList = UocRu.jsl(list, UocTodoPo.class);
        uocTodoMapper.insertBatch(recordPoList);
    }

    @Override
    public UocCfcParamConfigDo qryCfcParamByCode(String paramCode) {
        UocCfcParamConfigDo retDo = new UocCfcParamConfigDo();
        CfcParamConfigPo qryPo = new CfcParamConfigPo();
        qryPo.setParamConfigCode(paramCode);
        CfcParamConfigPo qryRspPo = cfcParamConfigMapper.getModelBy(qryPo);
        if (ObjectUtil.isNotEmpty(qryRspPo)) {
            BeanUtils.copyProperties(qryRspPo, retDo);
            CfcParamConfigItemPo qryItemPo = new CfcParamConfigItemPo();
            qryItemPo.setParamConfigCode(paramCode);
            List<CfcParamConfigItemPo> itemListPo = cfcParamConfigItemMapper.getList(qryItemPo);
            if (ObjectUtil.isNotEmpty(itemListPo)) {
                retDo.setItemList(JUtil.jsl(itemListPo, UocCfcParamConfigItemDo.class));
            }
        }
        return retDo;
    }

    @Override
    public UocCfcParamConfigItemDo updateCfcItemValue(UocCfcParamConfigItemDo reqDo) {
        CfcParamConfigItemPo where = new CfcParamConfigItemPo();
        CfcParamConfigItemPo set = new CfcParamConfigItemPo();
        where.setItemId(reqDo.getItemId());
        set.setItemValue(reqDo.getItemValue());
        set.setCreateTime(reqDo.getCreateTime());
        set.setCreateId(reqDo.getCreateId());
        set.setCreateName(reqDo.getCreateName());
        cfcParamConfigItemMapper.updateBy(set,where);
        return reqDo;
    }

    @Override
    public UocQryMateriaOrderNoBo qryMateriaBySkuIdAndUserId(UocQryMateriaOrderNoBo qryBo) {
        return uocSaleItemMapMapper.qryMateriaBySkuIdAndUserId(qryBo);
    }

    @Override
    public UocQrySaleOrderStageBO qrySaleOrderStageByOrderStateAndprocState(UocQrySaleOrderStageBO qryBo){
        return uocSaleOrderStateToStageConfigMapper.getOrderStageByOrderStateAndProcState(qryBo);
    }

    @Override
    public UocConfSupplierBo qryConfSupplier(String goodsSupplierNo) {
        UocConfSupplierPo uocConfSupplierPo = new UocConfSupplierPo();
        uocConfSupplierPo.setSupNo(goodsSupplierNo);
        uocConfSupplierPo = uocConfSupplierMapper.getModelBy(uocConfSupplierPo);
        return ObjectUtil.isNotEmpty(uocConfSupplierPo)? UocRu.js(uocConfSupplierPo,UocConfSupplierBo.class):new UocConfSupplierBo();
    }

    @Override
    public List<UocConfSupplierDO> qryConfSupplierList(UocConfSupplierDO uocConfSupplierDO) {
        UocConfSupplierPo qrySupConfPo = new UocConfSupplierPo();
        qrySupConfPo.setSupplierNos(uocConfSupplierDO.getSupplierNos());
        qrySupConfPo.setLimitStatus(uocConfSupplierDO.getLimitStatus());
        qrySupConfPo.setSupNo(uocConfSupplierDO.getSupNo());
        qrySupConfPo.setBusinessTypeCode(uocConfSupplierDO.getBusinessTypeCode());
        List<UocConfSupplierPo> confSupplierList = uocConfSupplierMapper.getList(qrySupConfPo);
        return ObjectUtil.isNotEmpty(confSupplierList)? UocRu.jsl(confSupplierList, UocConfSupplierDO.class): new ArrayList<>();
    }
}
