package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocBargainingQuotationPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：议价单报价表
 * 
 * @author 文乐
 * @date 2023-07-21 18:11
 **/
@Mapper
@Repository
public interface UocBargainingQuotationMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocBargainingQuotationPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocBargainingQuotationPO uocBargainingQuotationPo);

	/**
	 * 根据条件删除数据
	 *
	 * @param uocBargainingQuotationPo 参数对象
	 * @return int 影响数量
	 */
	int deleteBy(UocBargainingQuotationPO uocBargainingQuotationPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocBargainingQuotationPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocBargainingQuotationPO uocBargainingQuotationPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocBargainingQuotationPO set, @Param("where") UocBargainingQuotationPO where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocBargainingQuotationPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocBargainingQuotationPO uocBargainingQuotationPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocBargainingQuotationPo 参数对象
	 * @return UocBargainingQuotationPO 结果对象
	 */
	UocBargainingQuotationPO getModelBy(UocBargainingQuotationPO uocBargainingQuotationPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocBargainingQuotationPo 参数对象
	 * @return List<UocBargainingQuotationPO> 结果对象
	 */
	List<UocBargainingQuotationPO> getList(UocBargainingQuotationPO uocBargainingQuotationPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocBargainingQuotationPo 参数对象
	 * @param page 分页参数
	 * @return List<UocBargainingQuotationPO> 结果对象
	 */
	List<UocBargainingQuotationPO> getListPage(UocBargainingQuotationPO uocBargainingQuotationPo, Page<UocBargainingQuotationPO> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocBargainingQuotationPO> list);

}
