package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocShipOrderItemPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocShipOrderItemMapper
 * 说明:发货明细
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocShipOrderItemMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocShipOrderItemPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocShipOrderItemPo uocShipOrderItemPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocShipOrderItemPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocShipOrderItemPo uocShipOrderItemPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocShipOrderItemPo set, @Param("where") UocShipOrderItemPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocShipOrderItemPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocShipOrderItemPo uocShipOrderItemPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocShipOrderItemPo 参数对象
	 * @return UocShipOrderItemPo 结果对象
	 */
	UocShipOrderItemPo getModelBy(UocShipOrderItemPo uocShipOrderItemPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocShipOrderItemPo 参数对象
	 * @return List<UocShipOrderItemPo> 结果对象
	 */
	List<UocShipOrderItemPo> getList(UocShipOrderItemPo uocShipOrderItemPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocShipOrderItemPo 参数对象
	 * @param page 分页参数
	 * @return List<UocShipOrderItemPo> 结果对象
	 */
	List<UocShipOrderItemPo> getListPage(UocShipOrderItemPo uocShipOrderItemPo, Page<UocShipOrderItemPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocShipOrderItemPo> list);

	/**
	 * 批量更新到货数量
	 */
	void updateItemArriveCount(UocShipOrderItemPo uocShipOrderItemPo);

	/**
	 * 批量更新拒收数量
	 */
	void updateItemRefuseCount(UocShipOrderItemPo uocShipOrderItemPo);

	/**
	 * 更新验收数量
	 */
	void updateItemInspCount(@Param("list") List<UocShipOrderItemPo> list, @Param("uocShipOrderItemPo") UocShipOrderItemPo uocShipOrderItemPo);

	/**
	 * 更新异常变更在途数量
	 */
	void updateItemChngingCount(@Param("list") List<UocShipOrderItemPo> list, @Param("uocShipOrderItemPo") UocShipOrderItemPo uocShipOrderItemPo);

	/**
	 * 更新发货明细退货数量 依据异常变更在途数量更新
	 */
	void updateItemReturnCountByChngingCount(UocShipOrderItemPo uocShipOrderItemPo);

	void updateItemReturnCountZero(UocShipOrderItemPo uocShipOrderItemPo);
	/**
	 * 更新验收数量=到货数量
	 */
	void modifyShipOrderItemInspCountEqualArrivalCount(UocShipOrderItemPo uocShipOrderItemPo);

    void modifyItemArriveCountConfirm(UocShipOrderItemPo uocShipOrderItemPo);

	void modifyItemRefuseCountConfirm(UocShipOrderItemPo uocShipOrderItemPo);
    
    /**
     * 根据条件更新数据
     *
     * @param set set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateItemArriveCountAndRefuseAccount(@Param("set") UocShipOrderItemPo set, @Param("where") UocShipOrderItemPo where);
	
}
