package com.tydic.dyc.oc.repository.po;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocAfOrderItemPo
 * 说明:售后服务明细
 * 时间:2022-04-12 19:47
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocAfOrderItemPo implements Serializable {
	private static final long serialVersionUID = 3237039735227413186L;

	//服务明细id")
	private Long afOrderItemId;

	//售后服务单id")
	private Long afOrderId;

	//验收明细id")
	private Long inspItemId;

	//发货明细id")
	private Long shipItemId;

	//销售明细id")
	private Long saleItemId;

	//订单id")
	private Long orderId;

	//外部售后服务单号")
	private String extAfId;

	//外部订单编号")
	private String extOrderId;

	//销售单id")
	private Long saleOrderId;

	//单品id")
	private Long skuId;

	//计量单位")
	private String unitName;

	//采购数量")
	private BigDecimal purchaseCount;

	//售后服务量")
	private BigDecimal returnCount;

	//币种")
	private String currencyType;

	//销售退款金额")
	private BigDecimal retSaleFee;

	//采购退款金额")
	private BigDecimal retPurchaseFee;

	//是否有包装")
	private Integer ishaspackage;

	//包装描述             0 无包装              10 包装完整              20 包装破损             暂不需要             ")
	private Integer packageDesc;

	//问题描述")
	private String questionDesc;

	//是否需要检测报告")
	private Integer isNeedDetectionReport;

	//创建时间")
	private Date createTime;

	//创建时间 开始")
	private Date createTimeStart;

	//创建时间 结束")
	private Date createTimeEnd;

	//创建工号")
	private String createOperId;

	//更新时间")
	private Date updateTime;

	//更新时间 开始")
	private Date updateTimeStart;

	//更新时间 结束")
	private Date updateTimeEnd;

	//更新工号")
	private String updateOperId;

	//备注")
	private String remark;

	//删除标志1已删除")
	private Integer delTag;

	//扩展字段1")
	private String extField1;

	//扩展字段2")
	private String extField2;

	//扩展字段3")
	private String extField3;

	//扩展字段4")
	private String extField4;

	//扩展字段5")
	private String extField5;

	//排序")
	private String orderBy;

}
