package com.tydic.dyc.oc.repository.po;

import lombok.Data;
import java.io.Serializable;
import java.util.Date;
import java.math.BigDecimal;

/**
 * 描述：议价单申请表
 * 
 * @author 文乐
 * @date 2023-07-21 18:12
 **/
@Data
public class UocBargainingPO implements Serializable {
	private static final long serialVersionUID =  -7172571100190522593L;

	/**
	 * 议价单id
	 */
	private Long bargainingId;
	/**
	 * 议价单编码
	 */
	private String bargainingNo;
	/**
	 * 议价单父id
	 */
	private Long bargainingParentId;
	/**
	 * 流程实例id
	 */
	private String procInstId;
	/**
	 *  议价单类型 :1.采购电商 2, 无协议
             采购方发起，供应发起
	 */
	private Integer bargainingType;
	/**
	 * 结算模式 2:撮合 1:贸易
	 */
	private Integer modelSettle;
	/**
	 * 议价单状态
            1000 报价中
            1001 已报价
            1002 已终止
            1003 已下单
	 */
	private String bargainingState;
	/**
	 * 采购方公司id
	 */
	private String purCompanyId;
	/**
	 * 采购公司编码
	 */
	private String purCompanyNo;
	/**
	 * 采购方公司名称
	 */
	private String purCompanyName;
	/**
	 * 采购方机构id
	 */
	private String purOrgId;
	/**
	 * 采购方机构编码
	 */
	private String purOrgNo;
	/**
	 * 采购方机构名称
	 */
	private String purOrgName;
	/**
	 * 供应商ID
	 */
	private String supId;
	/**
	 * 供应商编码
	 */
	private String supNo;
	/**
	 * 供应商名称
	 */
	private String supplierName;
	/**
	 * 运营单位机构id
	 */
	private String proId;
	/**
	 * 运营单位机构编码
	 */
	private String proNo;
	/**
	 * 运营机构名称
	 */
	private String proName;
	/**
	 * 送货时间
	 */
	private Date quotationExpiryTime;
	private Date quotationExpiryTimeStart;
	private Date quotationExpiryTimeEnd;
	/**
	 * 收货地址ID
	 */
	private Long addressId;
	/**
	 * 报价最大轮次
	 */
	private Integer quoteMaxRound;
	/**
	 * 报价当前轮次
	 */
	private Integer quoteCurrentRound;
	/**
	 * 议价前商品总金额
	 */
	private BigDecimal totalPrice;
	/**
	 * 最终总专属报价，供应商报价成功后更新
	 */
	private BigDecimal totalCustomPrice;
	/**
	 * 总价折扣率
	 */
	private BigDecimal totalDiscountRate;
	/**
	 * 终止人ID
	 */
	private String cancelOperId;
	/**
	 * 终止时间
	 */
	private Date cancelTime;
	private Date cancelTimeStart;
	private Date cancelTimeEnd;
	/**
	 * 终止原因
	 */
	private String cancelReason;
	/**
	 * 议价人ID
	 */
	private String bargainingOperId;
	/**
	 * 议价人名称
	 */
	private String bargainingOperName;
	/**
	 * 创建时间
	 */
	private Date createTime;
	private Date createTimeStart;
	private Date createTimeEnd;
	/**
	 * 更新人ID
	 */
	private String updateOperId;
	/**
	 * 更新人名称
	 */
	private String updateOperName;
	/**
	 * 更新时间
	 */
	private Date updateTime;
	private Date updateTimeStart;
	private Date updateTimeEnd;
	/**
	 * 备注 填写给报价方稍的话
	 */
	private String remark;
	/**
	 * 扩展字段1
	 */
	private String extField1;
	/**
	 * 扩展字段2
	 */
	private String extField2;
	/**
	 * 扩展字段3
	 */
	private String extField3;
	/**
	 * 扩展字段4
	 */
	private String extField4;
	/**
	 * 扩展字段5
	 */
	private String extField5;
	/**
	 * 扩展字段6
	 */
	private String extField6;
	/**
	 * 扩展字段7
	 */
	private String extField7;
	/**
	 * 扩展字段8
	 */
	private String extField8;
	/**
	 * 扩展字段9
	 */
	private String extField9;
	/**
	 * 扩展字段10
	 */
	private String extField10;
	/**
	 * 排序
	 */
	private String orderBy;

}
