package com.tydic.dyc.oc.repository.po;

import lombok.Data;
import java.io.Serializable;
import java.util.Date;
import java.math.BigDecimal;

/**
 * 描述：议价单报价表
 * 
 * @author 文乐
 * @date 2023-07-21 18:12
 **/
@Data
public class UocBargainingQuotationPO implements Serializable {
	private static final long serialVersionUID =  621195808653028239L;

	/**
	 * 报价单id
	 */
	private Long quotationId;
	/**
	 * 议价单id
	 */
	private Long bargainingId;
	/**
	 * 报价截止日期
	 */
	private Date quotationExpiryTime;
	private Date quotationExpiryTimeStart;
	private Date quotationExpiryTimeEnd;
	/**
	 * 报价轮次
	 */
	private Integer quotationRound;
	/**
	 * 报价总金额
	 */
	private BigDecimal totalCustomPrice;
	/**
	 * 节省金额
	 */
	private BigDecimal savedPrice;
	/**
	 * 报价状态
            0未报价
            1已报价
            2: 多轮报价中
	 */
	private String quotationStatus;
	/**
	 * 报价人ID
	 */
	private Long quotationOperId;
	/**
	 * 报价人姓名
	 */
	private String quotationOperName;
	/**
	 * 报价时间
	 */
	private Date quotationTime;
	private Date quotationTimeStart;
	private Date quotationTimeEnd;
	/**
	 * 发起人id
	 */
	private Long createOperId;
	/**
	 * 发起人姓名
	 */
	private String createOperName;
	/**
	 * 创建时间
	 */
	private Date createTime;
	private Date createTimeStart;
	private Date createTimeEnd;
	/**
	 * 未报价原因
	 */
	private String quotationReason;
	/**
	 * 价格有效期 预留
	 */
	private Date validityTime;
	private Date validityTimeStart;
	private Date validityTimeEnd;
	/**
	 * 最新有效报价标志
            0 非最新
            1 最新报价
	 */
	private String newestFlag;
	/**
	 * 采购议价单编号 预留
	 */
	private String purQuotationNo;
	/**
	 * 扩展字段1
	 */
	private String extField1;
	/**
	 * 扩展字段2
	 */
	private String extField2;
	/**
	 * 扩展字段3
	 */
	private String extField3;
	/**
	 * 扩展字段4
	 */
	private String extField4;
	/**
	 * 扩展字段5
	 */
	private String extField5;
	/**
	 * 排序
	 */
	private String orderBy;

}
