package com.tydic.dyc.oc.repository.po;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 标题:UocOrdEvaluatePo
 * 说明:评价数据表
 * 时间:2022-04-11 16:47
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocOrdEvaluatePo implements Serializable {
	private static final long serialVersionUID = -8171385460917539702L;

	private Long id;

	//单据id")
	private Long objId;

	//单据类型             1订单             2.销售单             3 发货单             4.收货单             5.售后服务单             6支付单                          99.其他")
	private Integer objType;

	//订单id")
	private Long orderId;

	//评价状态,0未评价，1已评价，可以追评，2已评价，不可以追评，3评价超时，不可以追评，4已追评，5追评超时")
	private Integer evaluateState;

	//创建时间")
	private Date createTime;

	//创建时间 开始")
	private Date createTimeStart;

	//创建时间 结束")
	private Date createTimeEnd;

	//创建工号")
	private String createOperId;

	//更新时间")
	private Date updateTime;

	//更新时间 开始")
	private Date updateTimeStart;

	//更新时间 结束")
	private Date updateTimeEnd;

	//更新工号")
	private String updateOperId;

	//备注")
	private String remark;

	//删除标志1已删除")
	private Integer delTag;

	//排序")
	private String orderBy;

}
