package com.tydic.dyc.oc.repository.po;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 标题:UocOrderTaskInstLogPo
 * 说明:订单任务实例
 * 时间:2022-05-24 18:14
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocOrderTaskInstLogPo implements Serializable {
	private static final long serialVersionUID = 1430016678420840354L;

	//id")
	private Long id;

	//订单id")
	private Long orderId;

	//任务实例id")
	private String taskInstId;

	//单据id")
	private Long objId;

	//流程实例id")
	private String procInstId;

	//流程key定义")
	private String procDefId;

	//单据类型:1订单   2.销售单   3.执行单   4.发货单   5.收货单   6.售后服务单  7.支付单  8验收单，9审批单   99.其他")
	private Integer objType;

	//加签标识 0 ：环节任务   1：前加签任务  2：后加签任务  3：存在后加签任务")
	private Integer taskSignTag;

	//所在环节")
	private String procState;

	//表单url")
	private String formUrl;

	//创建时间")
	private Date createTime;

	//创建时间 开始")
	private Date createTimeStart;

	//创建时间 结束")
	private Date createTimeEnd;

	//完结标志0未完结1已完结")
	private Integer finishTag;

	//完成时间")
	private Date finishTime;

	//完成时间 开始")
	private Date finishTimeStart;

	//完成时间 结束")
	private Date finishTimeEnd;

	//删除标志1已删除")
	private Integer delTag;

	//排序")
	private String orderBy;

}
