package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocBargainingItemPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：议价单申请明细表
 *
 * @author 文乐
 * @date 2023-07-21 18:11
 **/
@Mapper
@Repository
public interface UocBargainingItemMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocBargainingItemPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocBargainingItemPO uocBargainingItemPo);

	/**
	 * 根据条件删除数据
	 *
	 * @param uocBargainingItemPo 参数对象
	 * @return int 影响数量
	 */
	int deleteBy(UocBargainingItemPO uocBargainingItemPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocBargainingItemPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocBargainingItemPO uocBargainingItemPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocBargainingItemPO set, @Param("where") UocBargainingItemPO where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocBargainingItemPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocBargainingItemPO uocBargainingItemPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocBargainingItemPo 参数对象
	 * @return UocBargainingItemPO 结果对象
	 */
	UocBargainingItemPO getModelBy(UocBargainingItemPO uocBargainingItemPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocBargainingItemPo 参数对象
	 * @return List<UocBargainingItemPO> 结果对象
	 */
	List<UocBargainingItemPO> getList(UocBargainingItemPO uocBargainingItemPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocBargainingItemPo 参数对象
	 * @param page 分页参数
	 * @return List<UocBargainingItemPO> 结果对象
	 */
	List<UocBargainingItemPO> getListPage(UocBargainingItemPO uocBargainingItemPo, Page<UocBargainingItemPO> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocBargainingItemPO> list);



	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocBargainingItemPo 参数对象
	 * @param page 分页参数
	 * @return List<UocBargainingItemPO> 结果对象
	 */
	List<UocBargainingItemPO> getListPageIn(UocBargainingItemPO uocBargainingItemPo, Page<UocBargainingItemPO> page);


	/**
	 * 根据条件分页查询最新列表数据
	 *
	 * @param uocBargainingItemPo 参数对象
	 * @param page 分页参数
	 * @return List<UocBargainingItemPO> 结果对象
	 */
	List<UocBargainingItemPO> getLastListPage(UocBargainingItemPO uocBargainingItemPo, Page<UocBargainingItemPO> page);


}
