package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocOrderQueryIndexPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocOrderQueryIndexMapper
 * 说明:外部系统单号关联表，主要用于关联电商的外部单号，提升查询效率
 * 时间:2022-04-06 16:03
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocOrderQueryIndexMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocOrderQueryIndexPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocOrderQueryIndexPo uocOrderQueryIndexPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocOrderQueryIndexPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocOrderQueryIndexPo uocOrderQueryIndexPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set   set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocOrderQueryIndexPo set, @Param("where") UocOrderQueryIndexPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocOrderQueryIndexPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocOrderQueryIndexPo uocOrderQueryIndexPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocOrderQueryIndexPo 参数对象
	 * @return UocOrderQueryIndexPo 结果对象
	 */
	UocOrderQueryIndexPo getModelBy(UocOrderQueryIndexPo uocOrderQueryIndexPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocOrderQueryIndexPo 参数对象
	 * @return List<UocOrderQueryIndexPo> 结果对象
	 */
	List<UocOrderQueryIndexPo> getList(UocOrderQueryIndexPo uocOrderQueryIndexPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocOrderQueryIndexPo 参数对象
	 * @param page                 分页参数
	 * @return List<UocOrderQueryIndexPo> 结果对象
	 */
	List<UocOrderQueryIndexPo> getListPage(UocOrderQueryIndexPo uocOrderQueryIndexPo, Page<UocOrderQueryIndexPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocOrderQueryIndexPo> list);

}
