package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocBargainingPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：议价单申请表
 * 
 * @author 文乐
 * @date 2023-07-21 18:11
 **/
@Mapper
@Repository
public interface UocBargainingMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocBargainingPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocBargainingPO uocBargainingPo);

	/**
	 * 根据条件删除数据
	 *
	 * @param uocBargainingPo 参数对象
	 * @return int 影响数量
	 */
	int deleteBy(UocBargainingPO uocBargainingPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocBargainingPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocBargainingPO uocBargainingPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocBargainingPO set, @Param("where") UocBargainingPO where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocBargainingPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocBargainingPO uocBargainingPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocBargainingPo 参数对象
	 * @return UocBargainingPO 结果对象
	 */
	UocBargainingPO getModelBy(UocBargainingPO uocBargainingPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocBargainingPo 参数对象
	 * @return List<UocBargainingPO> 结果对象
	 */
	List<UocBargainingPO> getList(UocBargainingPO uocBargainingPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocBargainingPo 参数对象
	 * @param page 分页参数
	 * @return List<UocBargainingPO> 结果对象
	 */
	List<UocBargainingPO> getListPage(UocBargainingPO uocBargainingPo, Page<UocBargainingPO> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocBargainingPO> list);

}
