package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.SystemBusiLogPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：system_busi_log
 * 
 * @author 文乐
 * @date 2023-07-21 18:09
 **/
@Mapper
@Repository
public interface SystemBusiLogMapper {

	/**
	 * 插入单条数据
	 *
	 * @param systemBusiLogPo 参数对象
	 * @return int 影响数量
	 */
	int insert(SystemBusiLogPO systemBusiLogPo);

	/**
	 * 根据条件删除数据
	 *
	 * @param systemBusiLogPo 参数对象
	 * @return int 影响数量
	 */
	int deleteBy(SystemBusiLogPO systemBusiLogPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param systemBusiLogPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(SystemBusiLogPO systemBusiLogPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") SystemBusiLogPO set, @Param("where") SystemBusiLogPO where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param systemBusiLogPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(SystemBusiLogPO systemBusiLogPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param systemBusiLogPo 参数对象
	 * @return SystemBusiLogPO 结果对象
	 */
	SystemBusiLogPO getModelBy(SystemBusiLogPO systemBusiLogPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param systemBusiLogPo 参数对象
	 * @return List<SystemBusiLogPO> 结果对象
	 */
	List<SystemBusiLogPO> getList(SystemBusiLogPO systemBusiLogPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param systemBusiLogPo 参数对象
	 * @param page 分页参数
	 * @return List<SystemBusiLogPO> 结果对象
	 */
	List<SystemBusiLogPO> getListPage(SystemBusiLogPO systemBusiLogPo, Page<SystemBusiLogPO> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<SystemBusiLogPO> list);

}
