package com.tydic.dyc.oc.repository.po;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocOrderTaskInstPo
 * 说明:订单任务实例
 * 时间:2022-05-25 14:59
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocOrderTaskInstPo implements Serializable {
	private static final long serialVersionUID = -6105494802130849067L;

	//id")
	private Long id;

	//id")
	private List<Long> ids;

	//订单id")
	private Long orderId;

	//任务实例id")
	private String taskInstId;

	//单据id")
	private Long objId;

	//流程实例id")
	private String procInstId;

	//流程key定义")
	private String procDefId;

	//单据类型:1订单   2.销售单   3.执行单   4.发货单   5.收货单   6.售后服务单  7.支付单  8验收单，9审批单   99.其他")
	private Integer objType;

	//加签标识 0 ：环节任务   1：前加签任务  2：后加签任务  3：存在后加签任务")
	private Integer taskSignTag;

	//处理人ID")
	private String dealOperId;

	//处理人姓名")
	private String dealOperName;

	//处理结果")
	private Integer dealResult;

	//处理备注")
	private String dealRemark;

	//所在环节")
	private String procState;

	//表单url")
	private String formUrl;

	//创建时间")
	private Date createTime;

	//创建时间 开始")
	private Date createTimeStart;

	//创建时间 结束")
	private Date createTimeEnd;

	//完结标志0未完结1已完结")
	private Integer finishTag;

	//完结标志 List 0未完结1已完结2结束任务")
	private List<Integer> finishTagList;

	//完成时间")
	private Date finishTime;

	//完成时间 开始")
	private Date finishTimeStart;

	//完成时间 结束")
	private Date finishTimeEnd;

	//删除标志1已删除")
	private Integer delTag;

	//排序")
	private String orderBy;

	//单据IDList")
	private List<Long> objIdList;

	//订单idList")
	private List<Long> orderIdList;

	//环节List")
	private List<String> procStateList;
	 //@DocField(value = "归档表后缀")
	private String dataAchiveTabSuffix;


}
