/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingParentDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingProgressRecordDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingQuotationDo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingItemQryBo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQryBo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQuotationBo;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargaining;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingItem;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingQuotationItem;
import com.tydic.dyc.oc.repository.UocBargainingRepository;
import com.tydic.dyc.oc.repository.dao.UocBargainingAddressMapper;
import com.tydic.dyc.oc.repository.dao.UocBargainingItemMapper;
import com.tydic.dyc.oc.repository.dao.UocBargainingMapper;
import com.tydic.dyc.oc.repository.dao.UocBargainingParentMapper;
import com.tydic.dyc.oc.repository.dao.UocBargainingProgressRecordMapper;
import com.tydic.dyc.oc.repository.dao.UocBargainingQuotationItemMapper;
import com.tydic.dyc.oc.repository.dao.UocBargainingQuotationMapper;
import com.tydic.dyc.oc.repository.po.UocBargainingAddressPO;
import com.tydic.dyc.oc.repository.po.UocBargainingItemPO;
import com.tydic.dyc.oc.repository.po.UocBargainingPO;
import com.tydic.dyc.oc.repository.po.UocBargainingParentPO;
import com.tydic.dyc.oc.repository.po.UocBargainingProgressRecordPO;
import com.tydic.dyc.oc.repository.po.UocBargainingQuotationItemPO;
import com.tydic.dyc.oc.repository.po.UocBargainingQuotationPO;
import com.tydic.dyc.oc.service.bargaining.UocBargainingItemPageBo;
import com.tydic.dyc.oc.service.bargaining.UocBargainingItemPageReqBo;
import com.tydic.dyc.oc.service.bargaining.UocBargainingItemPageRspBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocBargainingAddressBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingProgressRecordBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingProgressRecordReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryQuotationBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryQuotationListServiceReqBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocBargainingRepositoryImpl
implements UocBargainingRepository {
    @Autowired
    private UocBargainingMapper uocBargainingMapper;
    @Autowired
    private UocBargainingItemMapper uocBargainingItemMapper;
    @Autowired
    private UocBargainingParentMapper uocBargainingParentMapper;
    @Autowired
    private UocBargainingAddressMapper uocBargainingAddressMapper;
    @Autowired
    private UocBargainingProgressRecordMapper uocBargainingProgressRecordMapper;
    @Autowired
    private UocBargainingQuotationMapper uocBargainingQuotationMapper;
    @Autowired
    private UocBargainingQuotationItemMapper uocBargainingQuotationItemMapper;

    public List<UocBargaining> qryListBargaining(UocBargainingQryBo uocBargainingQryBo) {
        List<UocBargainingPO> list = this.uocBargainingMapper.getList((UocBargainingPO)UocRu.js((Object)uocBargainingQryBo, UocBargainingPO.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocBargaining.class) : new ArrayList();
    }

    public UocBargainingDo createBargaining(UocBargainingDo uocBargainingDo) {
        if (uocBargainingDo.getBargainingAddress() != null) {
            this.uocBargainingAddressMapper.insert((UocBargainingAddressPO)UocRu.js((Object)uocBargainingDo.getBargainingAddress(), UocBargainingAddressPO.class));
        }
        this.uocBargainingMapper.insert((UocBargainingPO)UocRu.js((Object)uocBargainingDo, UocBargainingPO.class));
        List bargainingItems = uocBargainingDo.getBargainingItems();
        if (ObjectUtil.isNotEmpty((Object)bargainingItems)) {
            ArrayList<UocBargainingItemPO> ordItemList = new ArrayList<UocBargainingItemPO>();
            for (UocBargainingItem bargainingItem : bargainingItems) {
                ordItemList.add((UocBargainingItemPO)UocRu.js((Object)bargainingItem, UocBargainingItemPO.class));
            }
            this.uocBargainingItemMapper.insertBatch(ordItemList);
        }
        UocBargainingProgressRecordPO uocBargainingProgressRecordPo = new UocBargainingProgressRecordPO();
        uocBargainingProgressRecordPo.setProgressRecordId(IdUtil.nextId());
        uocBargainingProgressRecordPo.setBargainingId(uocBargainingDo.getBargainingId());
        uocBargainingProgressRecordPo.setOperType(UocConstant.BARGAINING_OPER_TYPE.CREATE);
        uocBargainingProgressRecordPo.setOperTypeName("\u53d1\u8d77\u8bae\u4ef7");
        uocBargainingProgressRecordPo.setOperId(Long.valueOf(uocBargainingDo.getBargainingOperId()));
        uocBargainingProgressRecordPo.setOperName(uocBargainingDo.getBargainingOperName());
        uocBargainingProgressRecordPo.setOperTime(new Date());
        this.uocBargainingProgressRecordMapper.insert(uocBargainingProgressRecordPo);
        return uocBargainingDo;
    }

    public UocBargainingParentDo createBargainingParent(UocBargainingParentDo uocBargainingParentDo) {
        this.uocBargainingParentMapper.insert((UocBargainingParentPO)UocRu.js((Object)uocBargainingParentDo, UocBargainingParentPO.class));
        return uocBargainingParentDo;
    }

    public UocBargainingDo qryBargainingBy(UocBargainingDo uocBargainingDo) {
        UocBargainingPO uocBargainingPO = this.uocBargainingMapper.getModelBy((UocBargainingPO)UocRu.js((Object)uocBargainingDo, UocBargainingPO.class));
        return uocBargainingPO != null ? (UocBargainingDo)UocRu.js((Object)uocBargainingPO, UocBargainingDo.class) : null;
    }

    public void updateBargaining(UocBargainingDo uocBargainingDo) {
        UocBargainingPO where = new UocBargainingPO();
        where.setBargainingId(uocBargainingDo.getBargainingId());
        this.uocBargainingMapper.updateBy((UocBargainingPO)UocRu.js((Object)uocBargainingDo, UocBargainingPO.class), where);
    }

    public List<UocBargainingItem> qryBargainingItemList(UocBargainingItemQryBo uocBargainingItemQryBo) {
        List<UocBargainingItemPO> list = this.uocBargainingItemMapper.getList((UocBargainingItemPO)UocRu.js((Object)uocBargainingItemQryBo, UocBargainingItemPO.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocBargainingItem.class) : new ArrayList();
    }

    public BasePageRspBo<UocBargainingItem> qryListPageBargainingItem(UocBargainingItemQryBo uocBargainingItemQryBo) {
        Page page = new Page(uocBargainingItemQryBo.getPageNo().intValue(), uocBargainingItemQryBo.getPageSize().intValue());
        List<UocBargainingItemPO> uocBargainingItemPOS = this.uocBargainingItemMapper.qryBargainingSkuListPage((UocBargainingItemPO)UocRu.js((Object)uocBargainingItemQryBo, UocBargainingItemPO.class), (Page<UocBargainingItemPO>)page);
        BasePageRspBo rspBo = new BasePageRspBo();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(UocRu.jsl(uocBargainingItemPOS, UocBargainingItem.class));
        return rspBo;
    }

    public List<UocQryBargainingProgressRecordBo> getList(UocQryBargainingProgressRecordReqBo reqBo) {
        UocBargainingProgressRecordPO qryBo = new UocBargainingProgressRecordPO();
        qryBo.setBargainingId(reqBo.getBargainingId());
        qryBo.setOrderBy("oper_time DESC");
        List<UocBargainingProgressRecordPO> list = this.uocBargainingProgressRecordMapper.getList(qryBo);
        List respList = UocRu.jsl(list, UocQryBargainingProgressRecordBo.class);
        return respList;
    }

    public UocBargainingAddressBo getModelBy(UocBargaining reqBo) {
        UocBargainingAddressPO qryBo = (UocBargainingAddressPO)UocRu.js((Object)reqBo, UocBargainingAddressPO.class);
        UocBargainingAddressPO modelBy = this.uocBargainingAddressMapper.getModelBy(qryBo);
        UocBargainingAddressBo uocBargainingAddressBo = (UocBargainingAddressBo)UocRu.js((Object)modelBy, UocBargainingAddressBo.class);
        return uocBargainingAddressBo;
    }

    public List<UocQryQuotationBo> qryListBargainingQuotatio(UocQryQuotationListServiceReqBo reqBo) {
        List<UocBargainingQuotationPO> list = this.uocBargainingQuotationMapper.getList((UocBargainingQuotationPO)UocRu.js((Object)reqBo, UocBargainingQuotationPO.class));
        return CollUtil.isNotEmpty(list) ? UocRu.jsl(list, UocQryQuotationBo.class) : new ArrayList();
    }

    public UocBargainingItemPageRspBo qryBargainingItemPage(UocBargainingItemPageReqBo reqBo) {
        UocBargainingItemPageRspBo resp = new UocBargainingItemPageRspBo();
        BasePageRspBo rspPage = new BasePageRspBo();
        Page page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        List<Object> listPageIn = new ArrayList();
        UocBargainingItemPO qryReqBo = (UocBargainingItemPO)UocRu.js((Object)reqBo, UocBargainingItemPO.class);
        if ("1".equals(reqBo.getInterfaceType())) {
            listPageIn = this.uocBargainingItemMapper.getListPageIn(qryReqBo, (Page<UocBargainingItemPO>)page);
        } else if ("2".equals(reqBo.getInterfaceType())) {
            listPageIn = this.uocBargainingItemMapper.getLastListPage(qryReqBo, (Page<UocBargainingItemPO>)page);
        }
        Long quotationId2Interf = null;
        if ("2".equals(reqBo.getInterfaceType())) {
            UocBargainingQuotationPO lastByBargainingId = this.uocBargainingQuotationMapper.getLastByBargainingId(reqBo.getBargainingId());
            quotationId2Interf = lastByBargainingId.getQuotationId();
        }
        if (CollUtil.isNotEmpty(listPageIn)) {
            rspPage.setPageNo(page.getPageNo());
            rspPage.setTotal(page.getTotalPages());
            rspPage.setRecordsTotal(page.getTotalCount());
            rspPage.setRows(UocRu.jsl(listPageIn, UocBargainingItemPageBo.class));
            UocBargainingQuotationItemPO qryBo = new UocBargainingQuotationItemPO();
            if ("1".equals(reqBo.getInterfaceType())) {
                qryBo.setQuotationId(reqBo.getQuotationId());
            } else if ("2".equals(reqBo.getInterfaceType())) {
                qryBo.setQuotationId(quotationId2Interf);
            }
            List<UocBargainingQuotationItemPO> list = this.uocBargainingQuotationItemMapper.getList(qryBo);
            if (CollUtil.isNotEmpty(list)) {
                Map<Long, List<UocBargainingQuotationItemPO>> map = list.stream().collect(Collectors.groupingBy(UocBargainingQuotationItemPO::getBargainingItemId));
                rspPage.getRows().forEach(item -> {
                    item.setConfirmedPrice(((UocBargainingQuotationItemPO)((List)map.get(item.getBargainingItemId())).get(0)).getConfirmedPrice());
                    item.setConfirmedPriceSub(((UocBargainingQuotationItemPO)((List)map.get(item.getBargainingItemId())).get(0)).getConfirmedPriceSub());
                });
            }
        }
        UocBargainingQuotationPO qryQu = new UocBargainingQuotationPO();
        if ("1".equals(reqBo.getInterfaceType())) {
            qryQu.setQuotationId(reqBo.getQuotationId());
        } else if ("2".equals(reqBo.getInterfaceType())) {
            qryQu.setQuotationId(quotationId2Interf);
        }
        UocBargainingQuotationPO modelBy = this.uocBargainingQuotationMapper.getModelBy(qryQu);
        resp.setUocQryQuotationBo((UocQryQuotationBo)UocRu.js((Object)modelBy, UocQryQuotationBo.class));
        resp.setBasePageRspBo(rspPage);
        return resp;
    }

    public UocBargainingQuotationDo createQuotation(UocBargainingQuotationDo uocBargainingQuotationDo) {
        this.uocBargainingQuotationMapper.insert((UocBargainingQuotationPO)UocRu.js((Object)uocBargainingQuotationDo, UocBargainingQuotationPO.class));
        List bargainingQuotationItems = uocBargainingQuotationDo.getBargainingQuotationItems();
        if (ObjectUtil.isNotEmpty((Object)bargainingQuotationItems)) {
            ArrayList<UocBargainingQuotationItemPO> quotationItemList = new ArrayList<UocBargainingQuotationItemPO>();
            for (UocBargainingQuotationItem bargainingQuotationItem : bargainingQuotationItems) {
                quotationItemList.add((UocBargainingQuotationItemPO)UocRu.js((Object)bargainingQuotationItem, UocBargainingQuotationItemPO.class));
            }
            this.uocBargainingQuotationItemMapper.insertBatch(quotationItemList);
        }
        return uocBargainingQuotationDo;
    }

    public void updateQuotation(UocBargainingQuotationDo uocBargainingQuotationDo) {
        UocBargainingQuotationPO where = new UocBargainingQuotationPO();
        where.setBargainingId(uocBargainingQuotationDo.getBargainingId());
        where.setQuotationId(uocBargainingQuotationDo.getQuotationId());
        this.uocBargainingQuotationMapper.updateBy((UocBargainingQuotationPO)UocRu.js((Object)uocBargainingQuotationDo, UocBargainingQuotationPO.class), where);
    }

    public int updateQuotationItem(UocBargainingQuotationDo uocBargainingQuotationDo) {
        int updated = 0;
        List bargainingQuotationItems = uocBargainingQuotationDo.getBargainingQuotationItems();
        for (UocBargainingQuotationItem quotationItem : bargainingQuotationItems) {
            UocBargainingQuotationItemPO set = new UocBargainingQuotationItemPO();
            UocBargainingQuotationItemPO where = new UocBargainingQuotationItemPO();
            set.setConfirmedPrice(quotationItem.getConfirmedPrice());
            set.setSkuId(quotationItem.getSkuId());
            set.setSkuName(quotationItem.getSkuName());
            set.setSkuNum(new BigDecimal(quotationItem.getSkuNum()));
            set.setConfirmedBrandName(quotationItem.getConfirmedBrandName());
            set.setConfirmedModel(quotationItem.getConfirmedModel());
            set.setTaxPrice(quotationItem.getTaxPrice());
            set.setTaxRate(quotationItem.getTaxRate());
            set.setNakedPrice(quotationItem.getNakedPrice());
            set.setGreenFlag(quotationItem.getGreenFlag());
            set.setGreenFlagDesc(quotationItem.getGreenFlagDesc());
            set.setMicroCompanyFlag(quotationItem.getMicroCompanyFlag());
            set.setMicroCompanyFlagDesc(quotationItem.getMicroCompanyFlagDesc());
            set.setConfirmedPriceSub(quotationItem.getConfirmedPriceSub());
            where.setBargainingItemId(quotationItem.getBargainingItemId());
            where.setQuotationId(uocBargainingQuotationDo.getQuotationId());
            int i = this.uocBargainingQuotationItemMapper.updateBy(set, where);
            if (i != 1) continue;
            ++updated;
        }
        return updated;
    }

    public UocBargainingQuotationBo getQuotationBy(UocBargainingQuotationBo uocBargainingQuotationBo) {
        UocBargainingQuotationPO qryPo = (UocBargainingQuotationPO)UocRu.js((Object)uocBargainingQuotationBo, UocBargainingQuotationPO.class);
        UocBargainingQuotationPO modelBy = this.uocBargainingQuotationMapper.getModelBy(qryPo);
        UocBargainingQuotationBo bargainingQuotationBo = (UocBargainingQuotationBo)UocRu.js((Object)modelBy, UocBargainingQuotationBo.class);
        return bargainingQuotationBo;
    }

    public void insertProgressRecord(UocBargainingProgressRecordDo uocBargainingProgressRecordDo) {
        this.uocBargainingProgressRecordMapper.insert((UocBargainingProgressRecordPO)UocRu.js((Object)uocBargainingProgressRecordDo, UocBargainingProgressRecordPO.class));
    }

    public int updateBargainingItemConfirmedPrice(UocBargainingDo uocBargainingDo) {
        int updated = 0;
        List bargainingItems = uocBargainingDo.getBargainingItems();
        for (UocBargainingItem bargainingItem : bargainingItems) {
            UocBargainingItemPO set = new UocBargainingItemPO();
            UocBargainingItemPO where = new UocBargainingItemPO();
            set.setConfirmedPrice(bargainingItem.getConfirmedPrice());
            set.setSkuId(bargainingItem.getSkuId());
            set.setConfirmedPriceSub(bargainingItem.getConfirmedPriceSub());
            where.setBargainingId(bargainingItem.getBargainingId());
            where.setSkuId(bargainingItem.getSkuId());
            int i = this.uocBargainingItemMapper.updateBy(set, where);
            if (i != 1) continue;
            ++updated;
        }
        return updated;
    }

    public List<UocBargaining> qryExpireBargainingList(UocBargainingQryBo uocBargainingQryBo) {
        List<UocBargainingPO> list = this.uocBargainingMapper.qryExpireBargainingList((UocBargainingPO)UocRu.js((Object)uocBargainingQryBo, UocBargainingPO.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocBargaining.class) : new ArrayList();
    }
}

