package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocBargainingQuotationItemPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：议价单报价明细表
 * 
 * @author 文乐
 * @date 2023-07-21 18:11
 **/
@Mapper
@Repository
public interface UocBargainingQuotationItemMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocBargainingQuotationItemPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocBargainingQuotationItemPO uocBargainingQuotationItemPo);

	/**
	 * 根据条件删除数据
	 *
	 * @param uocBargainingQuotationItemPo 参数对象
	 * @return int 影响数量
	 */
	int deleteBy(UocBargainingQuotationItemPO uocBargainingQuotationItemPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocBargainingQuotationItemPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocBargainingQuotationItemPO uocBargainingQuotationItemPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocBargainingQuotationItemPO set, @Param("where") UocBargainingQuotationItemPO where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocBargainingQuotationItemPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocBargainingQuotationItemPO uocBargainingQuotationItemPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocBargainingQuotationItemPo 参数对象
	 * @return UocBargainingQuotationItemPO 结果对象
	 */
	UocBargainingQuotationItemPO getModelBy(UocBargainingQuotationItemPO uocBargainingQuotationItemPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocBargainingQuotationItemPo 参数对象
	 * @return List<UocBargainingQuotationItemPO> 结果对象
	 */
	List<UocBargainingQuotationItemPO> getList(UocBargainingQuotationItemPO uocBargainingQuotationItemPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocBargainingQuotationItemPo 参数对象
	 * @param page 分页参数
	 * @return List<UocBargainingQuotationItemPO> 结果对象
	 */
	List<UocBargainingQuotationItemPO> getListPage(UocBargainingQuotationItemPO uocBargainingQuotationItemPo, Page<UocBargainingQuotationItemPO> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocBargainingQuotationItemPO> list);

}
