package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocOrderStateChgLogPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocOrderStateChgLogMapper
 * 说明:订单状态变更记录表
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocOrderStateChgLogMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocOrderStateChgLogPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocOrderStateChgLogPo uocOrderStateChgLogPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocOrderStateChgLogPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocOrderStateChgLogPo uocOrderStateChgLogPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocOrderStateChgLogPo set, @Param("where") UocOrderStateChgLogPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocOrderStateChgLogPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocOrderStateChgLogPo uocOrderStateChgLogPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocOrderStateChgLogPo 参数对象
	 * @return UocOrderStateChgLogPo 结果对象
	 */
	UocOrderStateChgLogPo getModelBy(UocOrderStateChgLogPo uocOrderStateChgLogPo);


	/**
	 * 根据条件查询最后一条数据
	 *
	 * @param uocOrderStateChgLogPo 参数对象
	 * @return UocOrderStateChgLogPo 结果对象
	 */
	UocOrderStateChgLogPo getLastModelBy(UocOrderStateChgLogPo uocOrderStateChgLogPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocOrderStateChgLogPo 参数对象
	 * @return List<UocOrderStateChgLogPo> 结果对象
	 */
	List<UocOrderStateChgLogPo> getList(UocOrderStateChgLogPo uocOrderStateChgLogPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocOrderStateChgLogPo 参数对象
	 * @param page 分页参数
	 * @return List<UocOrderStateChgLogPo> 结果对象
	 */
	List<UocOrderStateChgLogPo> getListPage(UocOrderStateChgLogPo uocOrderStateChgLogPo, Page<UocOrderStateChgLogPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocOrderStateChgLogPo> list);

}
