package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingParentDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingProgressRecordDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingQuotationDo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingItemQryBo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQryBo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQuotationBo;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargaining;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingItem;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingQuotationItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.repository.UocBargainingRepository;
import com.tydic.dyc.oc.repository.dao.*;
import com.tydic.dyc.oc.repository.po.*;
import com.tydic.dyc.oc.service.bargaining.UocBargainingItemPageBo;
import com.tydic.dyc.oc.service.bargaining.UocBargainingItemPageReqBo;
import com.tydic.dyc.oc.service.bargaining.UocBargainingItemPageRspBo;
import com.tydic.dyc.oc.service.bargaining.bo.*;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题:UocBargainingRepositoryImpl
 * 说明:
 * 时间:2023/7/26 15:55
 * 作者:Dum
 */
@Service
public class UocBargainingRepositoryImpl implements UocBargainingRepository {
    @Autowired
    private UocBargainingMapper uocBargainingMapper;
    @Autowired
    private UocBargainingItemMapper uocBargainingItemMapper;
    @Autowired
    private UocBargainingParentMapper uocBargainingParentMapper;
    @Autowired
    private UocBargainingAddressMapper uocBargainingAddressMapper;
    @Autowired
    private UocBargainingProgressRecordMapper uocBargainingProgressRecordMapper;
    @Autowired
    private UocBargainingQuotationMapper uocBargainingQuotationMapper;
    @Autowired
    private UocBargainingQuotationItemMapper uocBargainingQuotationItemMapper;


    @Override
    public List<UocBargaining> qryListBargaining(UocBargainingQryBo uocBargainingQryBo) {
        List<UocBargainingPO> list = uocBargainingMapper.getList(UocRu.js(uocBargainingQryBo, UocBargainingPO.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocBargaining.class) : new ArrayList<>();
    }

    @Override
    public UocBargainingDo createBargaining(UocBargainingDo uocBargainingDo) {
        //保存地址信息（收货地址，发票地址）
        if (uocBargainingDo.getBargainingAddress() != null) {
            uocBargainingAddressMapper.insert(UocRu.js(uocBargainingDo.getBargainingAddress(), UocBargainingAddressPO.class));
        }
        //转换，保存议价单主体数据
        uocBargainingMapper.insert(UocRu.js(uocBargainingDo, UocBargainingPO.class));
        //议价单明细数据
        List<UocBargainingItem> bargainingItems = uocBargainingDo.getBargainingItems();
        if (ObjectUtil.isNotEmpty(bargainingItems)) {
            List<UocBargainingItemPO> ordItemList = new ArrayList<>();
            for (UocBargainingItem bargainingItem : bargainingItems) {
                ordItemList.add(UocRu.js(bargainingItem, UocBargainingItemPO.class));
            }
            uocBargainingItemMapper.insertBatch(ordItemList);
        }
        //记录操作记录
        UocBargainingProgressRecordPO uocBargainingProgressRecordPo = new UocBargainingProgressRecordPO();
        uocBargainingProgressRecordPo.setProgressRecordId(IdUtil.nextId());
        uocBargainingProgressRecordPo.setBargainingId(uocBargainingDo.getBargainingId());
        uocBargainingProgressRecordPo.setOperType(UocConstant.BARGAINING_OPER_TYPE.CREATE);
        uocBargainingProgressRecordPo.setOperTypeName("发起议价");
        uocBargainingProgressRecordPo.setOperId(Long.valueOf(uocBargainingDo.getBargainingOperId()));
        uocBargainingProgressRecordPo.setOperName(uocBargainingDo.getBargainingOperName());
        uocBargainingProgressRecordPo.setOperTime(new Date());
        uocBargainingProgressRecordMapper.insert(uocBargainingProgressRecordPo);
        return uocBargainingDo;
    }

    @Override
    public UocBargainingParentDo createBargainingParent(UocBargainingParentDo uocBargainingParentDo) {
        uocBargainingParentMapper.insert(UocRu.js(uocBargainingParentDo, UocBargainingParentPO.class));
        return uocBargainingParentDo;
    }

    @Override
    public UocBargainingDo qryBargainingBy(UocBargainingDo uocBargainingDo) {
        UocBargainingPO uocBargainingPO = uocBargainingMapper.getModelBy(UocRu.js(uocBargainingDo, UocBargainingPO.class));
        return uocBargainingPO != null ? UocRu.js(uocBargainingPO, UocBargainingDo.class) : null;
    }

    @Override
    public void updateBargaining(UocBargainingDo uocBargainingDo) {
        UocBargainingPO where = new UocBargainingPO();
        where.setBargainingId(uocBargainingDo.getBargainingId());
        uocBargainingMapper.updateBy(UocRu.js(uocBargainingDo, UocBargainingPO.class), where);
    }

    @Override
    public List<UocBargainingItem> qryBargainingItemList(UocBargainingItemQryBo uocBargainingItemQryBo) {
        List<UocBargainingItemPO> list = uocBargainingItemMapper.getList(UocRu.js(uocBargainingItemQryBo, UocBargainingItemPO.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocBargainingItem.class) : new ArrayList<>();
    }

    @Override
    public BasePageRspBo<UocBargainingItem> qryListPageBargainingItem(UocBargainingItemQryBo uocBargainingItemQryBo) {
        Page<UocBargainingItemPO> page = new Page<>(uocBargainingItemQryBo.getPageNo(), uocBargainingItemQryBo.getPageSize());
        List<UocBargainingItemPO> uocBargainingItemPOS = uocBargainingItemMapper.qryBargainingSkuListPage(UocRu.js(uocBargainingItemQryBo, UocBargainingItemPO.class), page);
        BasePageRspBo<UocBargainingItem> rspBo = new BasePageRspBo<>();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(UocRu.jsl(uocBargainingItemPOS, UocBargainingItem.class));
        return rspBo;
    }

    @Override
    public List<UocQryBargainingProgressRecordBo> getList(UocQryBargainingProgressRecordReqBo reqBo) {
        UocBargainingProgressRecordPO qryBo = new UocBargainingProgressRecordPO();
        qryBo.setBargainingId(reqBo.getBargainingId());
        qryBo.setOrderBy("oper_time DESC");
        List<UocBargainingProgressRecordPO> list = uocBargainingProgressRecordMapper.getList(qryBo);
        List<UocQryBargainingProgressRecordBo> respList = UocRu.jsl(list, UocQryBargainingProgressRecordBo.class);
        return respList;
    }


    @Override
    public UocBargainingAddressBo getModelBy(UocBargaining reqBo) {
        UocBargainingAddressPO qryBo = UocRu.js(reqBo, UocBargainingAddressPO.class);

        UocBargainingAddressPO modelBy = uocBargainingAddressMapper.getModelBy(qryBo);
        UocBargainingAddressBo uocBargainingAddressBo = UocRu.js(modelBy, UocBargainingAddressBo.class);
        return uocBargainingAddressBo;
    }


    @Override
    public List<UocQryQuotationBo> qryListBargainingQuotatio(UocQryQuotationListServiceReqBo reqBo) {
        List<UocBargainingQuotationPO> list = uocBargainingQuotationMapper.getList(UocRu.js(reqBo, UocBargainingQuotationPO.class));

        return CollUtil.isNotEmpty(list) ? UocRu.jsl(list, UocQryQuotationBo.class) : new ArrayList<>();
    }


    @Override
    public UocBargainingItemPageRspBo qryBargainingItemPage(UocBargainingItemPageReqBo reqBo) {
        UocBargainingItemPageRspBo resp = new UocBargainingItemPageRspBo();
        BasePageRspBo<UocBargainingItemPageBo> rspPage = new BasePageRspBo<>();

        Page<UocBargainingItemPO> page = new Page<>(reqBo.getPageNo(), reqBo.getPageSize());
        List<UocBargainingItemPO> listPageIn = new ArrayList<>();
        UocBargainingItemPO qryReqBo = UocRu.js(reqBo, UocBargainingItemPO.class);
        if ("1".equals(reqBo.getInterfaceType())) {
            listPageIn = uocBargainingItemMapper.getListPageIn(qryReqBo, page);
        } else if ("2".equals(reqBo.getInterfaceType())) {
            listPageIn = uocBargainingItemMapper.getLastListPage(qryReqBo, page);
        }
        Long quotationId2Interf = null;
        if ("2".equals(reqBo.getInterfaceType())) {
            UocBargainingQuotationPO lastByBargainingId = uocBargainingQuotationMapper.getLastByBargainingId(reqBo.getBargainingId());
            quotationId2Interf = lastByBargainingId.getQuotationId();
        }
        if (CollUtil.isNotEmpty(listPageIn)) {
            rspPage.setPageNo(page.getPageNo());
            rspPage.setTotal(page.getTotalPages());
            rspPage.setRecordsTotal(page.getTotalCount());
            rspPage.setRows(UocRu.jsl(listPageIn, UocBargainingItemPageBo.class));

            //设置单品报价信息
            UocBargainingQuotationItemPO qryBo = new UocBargainingQuotationItemPO();
            if ("1".equals(reqBo.getInterfaceType())) {
                qryBo.setQuotationId(reqBo.getQuotationId());
            } else if ("2".equals(reqBo.getInterfaceType())) {
                qryBo.setQuotationId(quotationId2Interf);
            }
            List<UocBargainingQuotationItemPO> list = uocBargainingQuotationItemMapper.getList(qryBo);
            if (CollUtil.isNotEmpty(list)) {
                Map<Long, List<UocBargainingQuotationItemPO>> map = list.stream().collect(Collectors.groupingBy(UocBargainingQuotationItemPO::getBargainingItemId));
                rspPage.getRows().forEach(item -> {
                    item.setConfirmedPrice(map.get(item.getBargainingItemId()).get(0).getConfirmedPrice());
                    item.setConfirmedPriceSub(map.get(item.getBargainingItemId()).get(0).getConfirmedPriceSub());
                });
            }
        }
        //设置总报价信息
        UocBargainingQuotationPO qryQu = new UocBargainingQuotationPO();
        if ("1".equals(reqBo.getInterfaceType())) {
            qryQu.setQuotationId(reqBo.getQuotationId());
        } else if ("2".equals(reqBo.getInterfaceType())) {
            qryQu.setQuotationId(quotationId2Interf);
        }
        UocBargainingQuotationPO modelBy = uocBargainingQuotationMapper.getModelBy(qryQu);
        resp.setUocQryQuotationBo(UocRu.js(modelBy, UocQryQuotationBo.class));
        resp.setBasePageRspBo(rspPage);
        return resp;
    }

    @Override
    public UocBargainingQuotationDo createQuotation(UocBargainingQuotationDo uocBargainingQuotationDo) {
        //转换，保存议价单报价主体数据
        uocBargainingQuotationMapper.insert(UocRu.js(uocBargainingQuotationDo, UocBargainingQuotationPO.class));
        //议价单报价明细初始化(报价金额无)
        List<UocBargainingQuotationItem> bargainingQuotationItems = uocBargainingQuotationDo.getBargainingQuotationItems();
        if (ObjectUtil.isNotEmpty(bargainingQuotationItems)) {
            List<UocBargainingQuotationItemPO> quotationItemList = new ArrayList<>();
            for (UocBargainingQuotationItem bargainingQuotationItem : bargainingQuotationItems) {
                quotationItemList.add(UocRu.js(bargainingQuotationItem, UocBargainingQuotationItemPO.class));
            }
            uocBargainingQuotationItemMapper.insertBatch(quotationItemList);
        }
        return uocBargainingQuotationDo;
    }

    @Override
    public void updateQuotation(UocBargainingQuotationDo uocBargainingQuotationDo) {
        UocBargainingQuotationPO where = new UocBargainingQuotationPO();
        where.setBargainingId(uocBargainingQuotationDo.getBargainingId());
        where.setQuotationId(uocBargainingQuotationDo.getQuotationId());
        uocBargainingQuotationMapper.updateBy(UocRu.js(uocBargainingQuotationDo, UocBargainingQuotationPO.class), where);
    }

    @Override
    public int updateQuotationItem(UocBargainingQuotationDo uocBargainingQuotationDo) {
        int updated = 0;
        List<UocBargainingQuotationItem> bargainingQuotationItems = uocBargainingQuotationDo.getBargainingQuotationItems();
        for (UocBargainingQuotationItem quotationItem : bargainingQuotationItems) {
            UocBargainingQuotationItemPO set = new UocBargainingQuotationItemPO();
            UocBargainingQuotationItemPO where = new UocBargainingQuotationItemPO();
            //更新set值
            set.setConfirmedPrice(quotationItem.getConfirmedPrice());
            set.setSkuName(quotationItem.getSkuName());
            set.setSkuNum(new BigDecimal(quotationItem.getSkuNum().intValue()));
            set.setConfirmedBrandName(quotationItem.getConfirmedBrandName());
            set.setConfirmedModel(quotationItem.getConfirmedModel());
            set.setTaxPrice(quotationItem.getTaxPrice());
            set.setTaxRate(quotationItem.getTaxRate());
            set.setNakedPrice(quotationItem.getNakedPrice());
            set.setGreenFlag(quotationItem.getGreenFlag());
            set.setGreenFlagDesc(quotationItem.getGreenFlagDesc());
            set.setMicroCompanyFlag(quotationItem.getMicroCompanyFlag());
            set.setMicroCompanyFlagDesc(quotationItem.getMicroCompanyFlagDesc());
            set.setConfirmedPriceSub(quotationItem.getConfirmedPriceSub());
            //条件
            where.setQuotationId(uocBargainingQuotationDo.getQuotationId());
            where.setSkuId(quotationItem.getSkuId());
            int i = uocBargainingQuotationItemMapper.updateBy(set, where);
            if (i == 1) {
                updated++;
            }
        }
        return updated;
    }

    @Override
    public UocBargainingQuotationBo getQuotationBy(UocBargainingQuotationBo uocBargainingQuotationBo) {
        UocBargainingQuotationPO qryPo = UocRu.js(uocBargainingQuotationBo, UocBargainingQuotationPO.class);
        UocBargainingQuotationPO modelBy = uocBargainingQuotationMapper.getModelBy(qryPo);
        UocBargainingQuotationBo bargainingQuotationBo = UocRu.js(modelBy, UocBargainingQuotationBo.class);
        return bargainingQuotationBo;
    }

    @Override
    public void insertProgressRecord(UocBargainingProgressRecordDo uocBargainingProgressRecordDo) {
        uocBargainingProgressRecordMapper.insert(UocRu.js(uocBargainingProgressRecordDo, UocBargainingProgressRecordPO.class));
    }

    @Override
    public int updateBargainingItemConfirmedPrice(UocBargainingDo uocBargainingDo) {
        int updated = 0;
        List<UocBargainingItem> bargainingItems = uocBargainingDo.getBargainingItems();
        for (UocBargainingItem bargainingItem : bargainingItems) {
            UocBargainingItemPO set = new UocBargainingItemPO();
            UocBargainingItemPO where = new UocBargainingItemPO();
            //更新set值
            set.setConfirmedPrice(bargainingItem.getConfirmedPrice());
            set.setConfirmedPriceSub(bargainingItem.getConfirmedPriceSub());
            //条件
            where.setBargainingId(bargainingItem.getBargainingId());
            where.setSkuId(bargainingItem.getSkuId());
            int i = uocBargainingItemMapper.updateBy(set, where);
            if (i == 1) {
                updated++;
            }
        }
        return updated;
    }

    @Override
    public List<UocBargaining> qryExpireBargainingList(UocBargainingQryBo uocBargainingQryBo) {
        List<UocBargainingPO> list = uocBargainingMapper.qryExpireBargainingList(UocRu.js(uocBargainingQryBo, UocBargainingPO.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocBargaining.class) : new ArrayList<>();
    }
}
