package com.tydic.dyc.oc.repository.po;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocOrderShouldPayPo
 * 说明:订单应付单表
 * 时间:2022-03-29 14:14
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocOrderShouldPayPo implements Serializable {
	private static final long serialVersionUID = -6825610605073310817L;

	//应付ID")
	private Long shouldPayId;

	//应付类型1：账期应付：2：预付款应付；3：成交服务费应付；4：平台使用费应付；5：到货款应付；6：验收款应付；7：质保金应付；")
	private Integer shouldPayType;

	//付款方式 0:预付款 2:账期支付")
	private Integer payType;

	//订单ID")
	private Long orderId;

	//单据ID")
	private Long objectId;

	//订单单据类型,1订单   2.销售单   3.执行单   4.发货单   5.收货单   6.售后服务单  7.支付单 8验收单  9审批单   99.其他")
	private Integer objectType;

	//订单单据编码")
	private String objectNo;

	//应付金额")
	private BigDecimal shouldPayAmount;

	//已付金额")
	private BigDecimal paidAmount;

	//退款金额")
	private BigDecimal backAmount;

	//是否支付完成：0：未支付；1：支付完成")
	private Integer isPayCompleted;

	//结算应付ID")
	private Long fscShouldPayId;

	//应付日期")
	private Date shouldPayDate;

	//应付日期 开始")
	private Date shouldPayDateStart;

	//应付日期 结束")
	private Date shouldPayDateEnd;

	//付款方ID")
	private Long payerId;

	//付款方名称")
	private String payerName;

	//收款方ID")
	private Long payeeId;

	//收款方名称")
	private String payeeName;

	//合同id")
	private String contractId;

	//合同编号")
	private String contractNo;

	//违约金")
	private BigDecimal penalty;

	//违约金比例")
	private BigDecimal penaltyRatio;

	//应该推送时间")
	private Date shouldPushTime;

	//应该推送时间 开始")
	private Date shouldPushTimeStart;

	//应该推送时间 结束")
	private Date shouldPushTimeEnd;

	//实际推送时间")
	private Date actualPushTime;

	//实际推送时间 开始")
	private Date actualPushTimeStart;

	//实际推送时间 结束")
	private Date actualPushTimeEnd;

	//支付配置ID")
	private Long payConfId;

	//支付金额类型")
	private Integer payFeeType;

	//创建时间")
	private Date createTime;

	//创建时间 开始")
	private Date createTimeStart;

	//创建时间 结束")
	private Date createTimeEnd;

	//创建人")
	private String createOperName;

	//创建工号")
	private String createOperId;

	//更新时间")
	private Date updateTime;

	//更新时间 开始")
	private Date updateTimeStart;

	//更新时间 结束")
	private Date updateTimeEnd;

	//更新工号")
	private String updateOperId;

	//更新人")
	private String updateOperName;

	//删除标志1已删除")
	private Integer delTag;

	//排序")
	private String orderBy;

	//单据id集合")
	private List<Long> objectIdList;
	 //@DocField(value = "归档表后缀")
	private String dataAchiveTabSuffix;
}
