package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocOrderGoodsMapPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocOrderGoodsMapMapper
 * 说明:快照扩展
 * 时间:2022-02-22 16:09
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocOrderGoodsMapMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocOrderGoodsMapPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocOrderGoodsMapPo uocOrderGoodsMapPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocOrderGoodsMapPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocOrderGoodsMapPo uocOrderGoodsMapPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocOrderGoodsMapPo set, @Param("where") UocOrderGoodsMapPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocOrderGoodsMapPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocOrderGoodsMapPo uocOrderGoodsMapPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocOrderGoodsMapPo 参数对象
	 * @return UocOrderGoodsMapPo 结果对象
	 */
	UocOrderGoodsMapPo getModelBy(UocOrderGoodsMapPo uocOrderGoodsMapPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocOrderGoodsMapPo 参数对象
	 * @return List<UocOrderGoodsMapPo> 结果对象
	 */
	List<UocOrderGoodsMapPo> getList(UocOrderGoodsMapPo uocOrderGoodsMapPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocOrderGoodsMapPo 参数对象
	 * @param page 分页参数
	 * @return List<UocOrderGoodsMapPo> 结果对象
	 */
	List<UocOrderGoodsMapPo> getListPage(UocOrderGoodsMapPo uocOrderGoodsMapPo, Page<UocOrderGoodsMapPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocOrderGoodsMapPo> list);

}
