package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocOrderTaskDealPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocOrderTaskDealMapper
 * 说明:订单任务处理对象表
 * 时间:2022-03-01 17:53
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocOrderTaskDealMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocOrderTaskDealPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocOrderTaskDealPo uocOrderTaskDealPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocOrderTaskDealPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocOrderTaskDealPo uocOrderTaskDealPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set   set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocOrderTaskDealPo set, @Param("where") UocOrderTaskDealPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocOrderTaskDealPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocOrderTaskDealPo uocOrderTaskDealPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocOrderTaskDealPo 参数对象
	 * @return UocOrderTaskDealPo 结果对象
	 */
	UocOrderTaskDealPo getModelBy(UocOrderTaskDealPo uocOrderTaskDealPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocOrderTaskDealPo 参数对象
	 * @return List<UocOrderTaskDealPo> 结果对象
	 */
	List<UocOrderTaskDealPo> getList(UocOrderTaskDealPo uocOrderTaskDealPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocOrderTaskDealPo 参数对象
	 * @param page               分页参数
	 * @return List<UocOrderTaskDealPo> 结果对象
	 */
	List<UocOrderTaskDealPo> getListPage(UocOrderTaskDealPo uocOrderTaskDealPo, Page<UocOrderTaskDealPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocOrderTaskDealPo> list);

}
