package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocBargainingParentPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：议价单父表
 * 
 * @author 文乐
 * @date 2023-07-21 18:11
 **/
@Mapper
@Repository
public interface UocBargainingParentMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocBargainingParentPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocBargainingParentPO uocBargainingParentPo);

	/**
	 * 根据条件删除数据
	 *
	 * @param uocBargainingParentPo 参数对象
	 * @return int 影响数量
	 */
	int deleteBy(UocBargainingParentPO uocBargainingParentPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocBargainingParentPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocBargainingParentPO uocBargainingParentPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocBargainingParentPO set, @Param("where") UocBargainingParentPO where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocBargainingParentPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocBargainingParentPO uocBargainingParentPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocBargainingParentPo 参数对象
	 * @return UocBargainingParentPO 结果对象
	 */
	UocBargainingParentPO getModelBy(UocBargainingParentPO uocBargainingParentPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocBargainingParentPo 参数对象
	 * @return List<UocBargainingParentPO> 结果对象
	 */
	List<UocBargainingParentPO> getList(UocBargainingParentPO uocBargainingParentPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocBargainingParentPo 参数对象
	 * @param page 分页参数
	 * @return List<UocBargainingParentPO> 结果对象
	 */
	List<UocBargainingParentPO> getListPage(UocBargainingParentPO uocBargainingParentPo, Page<UocBargainingParentPO> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocBargainingParentPO> list);

}
