package com.tydic.dyc.oc.repository.po;

import lombok.Data;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 描述：议价单报价明细表
 * 
 * @author 文乐
 * @date 2023-07-21 18:12
 **/
@Data
public class UocBargainingQuotationItemPO implements Serializable {
	private static final long serialVersionUID =  6909144968810187081L;

	/**
	 * 报价明细ID
	 */
	private Long quotationItemId;
	/**
	 * 报价单id
	 */
	private Long quotationId;
	/**
	 * 议价单明细id
	 */
	private Long bargainingItemId;
	/**
	 * 议价单id
	 */
	private Long bargainingId;
	/**
	 * 期望价格（开发预留）
	 */
	private BigDecimal expectPrice;
	/**
	 * 报价 (接口返回)
	 */
	private BigDecimal confirmedPrice;
	/**
	 * 单价折扣率
	 */
	private BigDecimal discountRate;
	/**
	 * 专属报价小计,报价*报价数量
	 */
	private BigDecimal confirmedPriceSub;
	/**
	 * 备注
	 */
	private String remark;
	/**
	 * 报价商品编码
	 */
	private Long skuId;
	/**
	 * 外部单品ID(接口返回)
	 */
	private String extSkuId;
	/**
	 * 报价商品名称(接口返回)
	 */
	private String skuName;
	/**
	 * 报价商品数量(接口返回)
	 */
	private BigDecimal skuNum;
	/**
	 * 报价品牌
	 */
	private String confirmedBrandName;
	/**
	 * 报价型号
	 */
	private String confirmedModel;
	/**
	 * 税率
	 */
	private String taxRate;
	/**
	 * 未税价
	 */
	private BigDecimal nakedPrice;
	/**
	 * 税价
	 */
	private BigDecimal taxPrice;
	/**
	 * 是否为环保产品
	 */
	private Integer greenFlag;
	/**
	 * 是否环保产品描述
	 */
	private String greenFlagDesc;
	/**
	 * 是否为小微企业
	 */
	private Integer microCompanyFlag;
	/**
	 * 是否为小微企业描述
	 */
	private String microCompanyFlagDesc;
	/**
	 * 扩展字段1
	 */
	private String extField1;
	/**
	 * 扩展字段2
	 */
	private String extField2;
	/**
	 * 扩展字段3
	 */
	private String extField3;
	/**
	 * 扩展字段4
	 */
	private String extField4;
	/**
	 * 扩展字段5
	 */
	private String extField5;
	/**
	 * 排序
	 */
	private String orderBy;

}
