package com.tydic.dyc.oc.repository.po;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocImplOrderItemPo
 * 说明:执行单明细
 * 时间:2022-03-09 14:13
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocImplOrderItemPo implements Serializable {
	private static final long serialVersionUID = 472046558853290479L;

	//订单id")
	private Long orderId;

	//销售单id")
	private Long saleOrderId;

	//执行明细id")
	private Long implOrderItemId;

	//销售明细id")
	private Long saleOrderItemId;


	//明细状态")
	private String implItemState;

	//明细类型             1 商品sku             2 物资             3 项目")
	private Integer itemType;

	//单品ID")
	private String skuId;

	//供应商ID")
	private String supplierId;

	//店铺ID")
	private String supplierShopId;

	//协议编号")
	private String agreementNo;

	//协议明细编号")
	private String agreementItemNo;

	//计量单位")
	private String unitName;

	//结算计量单位")
	private String settleUnit;

	//采购金额")
	private BigDecimal purchasePrice;

	//采购金额")
	private BigDecimal salePrice;

	//销售金额")
	private BigDecimal saleFee;

	//采购金额")
	private BigDecimal purchaseFee;

	//应付金额")
	private BigDecimal payFee;

	//采购数量")
	private BigDecimal purchaseCount;

	//发货数量")
	private BigDecimal sendCount;

	//到货数量")
	private BigDecimal arriveCount;

	//拒收数量")
	private BigDecimal refuseCount;

	//验收数量")
	private BigDecimal acceptanceCount;

	//退货数量")
	private BigDecimal returnCount;

	//异常变更在途数量，表示异常供应商确认之前的记录数量")
	private BigDecimal chngingCount;

	//售后在途数量")
	private BigDecimal afterServingCount;

	//运费")
	private BigDecimal transFee;

	//积分优惠金额")
	private BigDecimal integralDisFee;

	//活动优惠金额")
	private BigDecimal actDisFee;

	//其它优惠金额")
	private BigDecimal otherDisFee;

	//实付金额")
	private BigDecimal usedFee;

	//实付积分")
	private BigDecimal usedIntegral;

	//币种")
	private String currencyType;

	//税金")
	private String taxPrice;

	//税率")
	private String tax;

	//税务编码")
	private String taxId;

	//超验百分比，下单时保存（协议、无协议）")
	private Integer inspectionExcessPercent;

	//扩展字段")
	private String extField1;

	//扩展字段")
	private String extField2;

	//扩展字段")
	private String extField3;

	//扩展字段")
	private String extField4;

	//扩展字段")
	private String extField5;

	//创建时间")
	private Date createTime;

	//创建时间 开始")
	private Date createTimeStart;

	//创建时间 结束")
	private Date createTimeEnd;

	//创建工号")
	private String createOperId;

	//更新时间")
	private Date updateTime;

	//更新时间 开始")
	private Date updateTimeStart;

	//更新时间 结束")
	private Date updateTimeEnd;

	//更新工号")
	private String updateOperId;

	//备注")
	private String remark;

	//删除标志1已删除")
	private Integer delTag;

	//排序")
	private String orderBy;

	//执行单明细IDList")
	private List<Long> implOrderItemIdList;

	//订单IDList")
	private List<Long> orderIdList;
	 //@DocField(value = "归档表后缀")
	private String dataAchiveTabSuffix;

}
