/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.config.UocPropertiesConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderMap;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.repository.UocInspOrderRepository;
import com.tydic.dyc.oc.repository.dao.UocInspItemMapMapper;
import com.tydic.dyc.oc.repository.dao.UocInspOrderItemMapper;
import com.tydic.dyc.oc.repository.dao.UocInspOrderMapMapper;
import com.tydic.dyc.oc.repository.dao.UocInspOrderMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderAccessoryMapper;
import com.tydic.dyc.oc.repository.dao.UocShipInspRelMapper;
import com.tydic.dyc.oc.repository.po.UocInspItemMapPo;
import com.tydic.dyc.oc.repository.po.UocInspOrderItemPo;
import com.tydic.dyc.oc.repository.po.UocInspOrderMapPo;
import com.tydic.dyc.oc.repository.po.UocInspOrderPo;
import com.tydic.dyc.oc.repository.po.UocOrderAccessoryPo;
import com.tydic.dyc.oc.repository.po.UocShipInspRelPo;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocInspOrderRepositoryImpl
implements UocInspOrderRepository {
    private static final Logger log = LoggerFactory.getLogger(UocInspOrderRepositoryImpl.class);
    @Autowired
    private UocInspOrderMapper uocInspOrderMapper;
    @Autowired
    private UocInspOrderItemMapper uocInspOrderItemMapper;
    @Autowired
    private UocInspOrderMapMapper uocInspOrderMapMapper;
    @Autowired
    private UocInspItemMapMapper uocInspItemMapMapper;
    @Autowired
    private UocShipInspRelMapper uocShipInspRelMapper;
    @Autowired
    private UocOrderAccessoryMapper uocOrderAccessoryMapper;
    @Autowired
    private UocPropertiesConfig uocPropertiesConfig;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    public void createInspOrder(UocInspOrderDo uocInspOrderDo) {
        this.uocInspOrderMapper.insert((UocInspOrderPo)UocRu.js((Object)uocInspOrderDo, UocInspOrderPo.class));
        this.uocInspOrderItemMapper.insertBatch(UocRu.jsl((List)uocInspOrderDo.getUocInspOrderItemList(), UocInspOrderItemPo.class));
        if (ObjectUtil.isNotEmpty((Object)uocInspOrderDo.getUocShipInspRelList())) {
            this.uocShipInspRelMapper.insertBatch(UocRu.jsl((List)uocInspOrderDo.getUocShipInspRelList(), UocShipInspRelPo.class));
        }
        if (!CollectionUtils.isEmpty((Collection)uocInspOrderDo.getExtParallelBoList())) {
            this.uocInspOrderMapMapper.insertBatch(UocRu.jsl((List)uocInspOrderDo.getExtParallelBoList(), UocInspOrderMapPo.class));
        }
        ArrayList<UocInspItemMapPo> inspItemMapPoList = new ArrayList<UocInspItemMapPo>();
        uocInspOrderDo.getUocInspOrderItemList().forEach(uocInspOrderItem -> {
            if (!CollectionUtils.isEmpty((Collection)uocInspOrderItem.getItemExtParallelBoList())) {
                inspItemMapPoList.addAll(UocRu.jsl((List)uocInspOrderItem.getItemExtParallelBoList(), UocInspItemMapPo.class));
            }
        });
        if (!CollectionUtils.isEmpty(inspItemMapPoList)) {
            this.uocInspItemMapMapper.insertBatch(inspItemMapPoList);
        }
    }

    public UocInspOrderDo getInspOrderMain(UocInspOrderQryBo uocInspOrderQryBo) {
        UocInspOrderPo uocInspOrderPo = new UocInspOrderPo();
        uocInspOrderPo.setInspOrderId(uocInspOrderQryBo.getInspOrderId());
        uocInspOrderPo.setDataAchiveTabSuffix(uocInspOrderQryBo.getDataAchiveTabSuffix());
        uocInspOrderPo = this.uocInspOrderMapper.getModelBy(uocInspOrderPo);
        UocInspOrderDo uocInspOrderDo = (UocInspOrderDo)UocRu.js((Object)uocInspOrderPo, UocInspOrderDo.class);
        if (null != uocInspOrderPo) {
            UocInspOrderMapPo uocInspOrderMapPo = new UocInspOrderMapPo();
            uocInspOrderMapPo.setInspOrderId(uocInspOrderQryBo.getInspOrderId());
            uocInspOrderMapPo.setDataAchiveTabSuffix(uocInspOrderQryBo.getDataAchiveTabSuffix());
            List<UocInspOrderMapPo> uocInspOrderMapPoList = this.uocInspOrderMapMapper.getList(uocInspOrderMapPo);
            uocInspOrderDo.setExtParallelBoList(UocRu.jsl(uocInspOrderMapPoList, UocInspOrderMap.class));
            UocShipInspRelPo uocShipInspRelPo = new UocShipInspRelPo();
            uocShipInspRelPo.setInspOrderId(uocInspOrderQryBo.getInspOrderId());
            uocShipInspRelPo.setDataAchiveTabSuffix(uocInspOrderQryBo.getDataAchiveTabSuffix());
            List<UocShipInspRelPo> uocShipInspRelPoList = this.uocShipInspRelMapper.getList(uocShipInspRelPo);
            uocInspOrderDo.setUocShipInspRelList(UocRu.jsl(uocShipInspRelPoList, UocShipInspRel.class));
            UocOrderAccessoryPo uocOrderAccessoryPo = new UocOrderAccessoryPo();
            uocOrderAccessoryPo.setOrderId(uocInspOrderQryBo.getOrderId());
            uocOrderAccessoryPo.setObjId(uocInspOrderQryBo.getInspOrderId());
            uocOrderAccessoryPo.setDataAchiveTabSuffix(uocInspOrderQryBo.getDataAchiveTabSuffix());
            List<UocOrderAccessoryPo> accessoryList = this.uocOrderAccessoryMapper.getList(uocOrderAccessoryPo);
            if (!CollectionUtils.isEmpty(accessoryList)) {
                uocInspOrderDo.setUocOrderAccessoryList(UocRu.jsl(accessoryList, UocOrderAccessory.class));
            }
        }
        return uocInspOrderDo;
    }

    public UocInspOrderDo getListInspOrderItem(UocInspOrderItemQryBo uocInspOrderItemQryBo) {
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        List<UocInspOrderItemPo> uocInspOrderItemPoList = this.uocInspOrderItemMapper.getList((UocInspOrderItemPo)UocRu.js((Object)uocInspOrderItemQryBo, UocInspOrderItemPo.class));
        log.info("\u9a8c\u6536\u5355\u660e\u7ec6\u5217\u8868\u67e5\u8be2mapper\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString(uocInspOrderItemPoList));
        if (!CollectionUtils.isEmpty(uocInspOrderItemPoList)) {
            uocInspOrderItemPoList.forEach(v -> v.setInspItemCount(v.getInspCount()));
        }
        uocInspOrderDo.setUocInspOrderItemList(UocRu.jsl(uocInspOrderItemPoList, UocInspOrderItem.class));
        return uocInspOrderDo;
    }

    public UocInspOrderDo getInspOrderItemList(UocInspOrderItemQryBo uocInspOrderItemQryBo) {
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        List<UocInspOrderItemPo> uocInspOrderItemPoList = this.uocInspOrderItemMapper.getItemList((UocInspOrderItemPo)UocRu.js((Object)uocInspOrderItemQryBo, UocInspOrderItemPo.class));
        log.info("\u9a8c\u6536\u5355\u660e\u7ec6\u5217\u8868\u67e5\u8be2mapper\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString(uocInspOrderItemPoList));
        if (!CollectionUtils.isEmpty(uocInspOrderItemPoList)) {
            uocInspOrderItemPoList.forEach(v -> v.setInspCount(v.getInspItemCount()));
        }
        uocInspOrderDo.setUocInspOrderItemList(UocRu.jsl(uocInspOrderItemPoList, UocInspOrderItem.class));
        return uocInspOrderDo;
    }

    public List<UocInspOrderDo> getListInspOrder(UocInspOrderQryBo uocInspOrderQryBo) {
        List<UocInspOrderPo> uocInspOrderPoList = this.uocInspOrderMapper.getList((UocInspOrderPo)UocRu.js((Object)uocInspOrderQryBo, UocInspOrderPo.class));
        return UocRu.jsl(uocInspOrderPoList, UocInspOrderDo.class);
    }

    public UocInspOrderDo qryTotalFeeAndCount(UocInspOrderQryBo uocInspOrderQryBo) {
        UocInspOrderPo uocInspOrderPo = (UocInspOrderPo)UocRu.js((Object)uocInspOrderQryBo, UocInspOrderPo.class);
        uocInspOrderPo = this.uocInspOrderMapper.qryTotalFeeAndCount(uocInspOrderPo);
        return (UocInspOrderDo)UocRu.js((Object)uocInspOrderPo, UocInspOrderDo.class);
    }

    public void modifySaleOrderItemReturningCount(UocInspOrderItem uocSaleOrderItem) {
        UocInspOrderItemPo uocInspOrderItemPo = new UocInspOrderItemPo();
        uocInspOrderItemPo.setOrderId(uocSaleOrderItem.getOrderId());
        uocInspOrderItemPo.setInspOrderItemId(uocSaleOrderItem.getInspOrderItemId());
        uocInspOrderItemPo = this.uocInspOrderItemMapper.getModelBy(uocInspOrderItemPo);
        UocInspOrderItemPo set = new UocInspOrderItemPo();
        set.setReturnCount(uocInspOrderItemPo.getReturnCount().subtract(uocSaleOrderItem.getReturnCount()));
        set.setUpdateTime(uocSaleOrderItem.getUpdateTime());
        set.setUpdateOperId(uocSaleOrderItem.getUpdateOperId());
        UocInspOrderItemPo where = new UocInspOrderItemPo();
        where.setOrderId(uocSaleOrderItem.getOrderId());
        where.setInspOrderItemId(uocSaleOrderItem.getInspOrderItemId());
        this.uocInspOrderItemMapper.updateBy(set, where);
    }

    public void modifyInspOrderItemChngingCount(UocInspOrderDo inspOrderDo) {
        this.uocInspOrderItemMapper.modifyInspOrderItemChngingCount(UocRu.jsl((List)inspOrderDo.getUocInspOrderItemList(), UocInspOrderItem.class), (UocInspOrderItem)UocRu.js((Object)inspOrderDo, UocInspOrderItem.class));
    }

    public void modifyItemChngCountRefuse(UocInspOrderDo convertInspOrderDo) {
        this.uocInspOrderItemMapper.modifyItemChngCountRefuse((UocInspOrderItem)UocRu.js((Object)convertInspOrderDo, UocInspOrderItem.class));
    }

    public void modifyItemChngCountConfirm(UocInspOrderDo convertInspOrderDo) {
        this.uocInspOrderItemMapper.modifyItemChngCountConfirm((UocInspOrderItem)UocRu.js((Object)convertInspOrderDo, UocInspOrderItem.class));
    }

    public void modifyBatchItemInspConfirm(UocInspOrderDo convertInspOrderDo) {
        this.uocInspOrderItemMapper.modifyBatchItemInspConfirm((UocInspOrderItem)UocRu.js((Object)convertInspOrderDo, UocInspOrderItem.class));
        this.uocInspOrderMapper.modifyInspPrice((UocInspOrderPo)UocRu.js((Object)convertInspOrderDo, UocInspOrderPo.class));
    }

    public void modifyItemChngCountConfirmAdd(UocInspOrderDo convertInspOrderDo) {
        this.uocInspOrderItemMapper.modifyItemChngCountConfirmAdd((UocInspOrderItem)UocRu.js((Object)convertInspOrderDo, UocInspOrderItem.class));
    }

    public void modifyItemChngCountConfirmReduce(UocInspOrderDo convertInspOrderDo) {
        this.uocInspOrderItemMapper.modifyItemChngCountConfirmReduce((UocInspOrderItem)UocRu.js((Object)convertInspOrderDo, UocInspOrderItem.class));
    }

    public void modifyInsporderChngTotalFeeConfirm(UocInspOrderDo convertInspOrderDo) {
        if (convertInspOrderDo.getTotalSaleFee().compareTo(BigDecimal.ZERO) >= 0) {
            this.uocInspOrderItemMapper.modifyInsporderChngTotalFeeConfirm((UocInspOrderItem)UocRu.js((Object)convertInspOrderDo, UocInspOrderItem.class), 1);
        } else {
            this.uocInspOrderItemMapper.modifyInsporderChngTotalFeeConfirm((UocInspOrderItem)UocRu.js((Object)convertInspOrderDo, UocInspOrderItem.class), 2);
        }
    }

    public void updateInspPayStatus(UocInspOrderDo updateDo) {
        UocInspOrderPo set = new UocInspOrderPo();
        set.setPayStatus(updateDo.getPayStatus());
        set.setUpdateTime(new Date());
        UocInspOrderPo where = new UocInspOrderPo();
        where.setOrderId(updateDo.getOrderId());
        where.setInspOrderId(updateDo.getInspOrderId());
        this.uocInspOrderMapper.updateBy(set, where);
    }

    public void batchSyncInsp() {
        int pageSize = this.uocPropertiesConfig.getSyncEsPageSize();
        Page page = new Page(this.uocPropertiesConfig.getSyncEsPageStart().intValue(), pageSize);
        List<UocInspOrderPo> listPage = this.uocInspOrderMapper.getListPage(new UocInspOrderPo(), (Page<UocInspOrderPo>)page);
        this.syncSaleEs(listPage);
        for (int i = 2; i <= page.getTotalPages(); ++i) {
            Page pageInner = new Page(i, pageSize);
            List<UocInspOrderPo> innerList = this.uocInspOrderMapper.getListPage(new UocInspOrderPo(), (Page<UocInspOrderPo>)pageInner);
            this.syncSaleEs(innerList);
        }
    }

    public void modifyItemRemainCountAdd(UocInspOrderDo convertInspOrderDo) {
        this.uocInspOrderItemMapper.modifyItemRemainCountAdd((UocInspOrderItem)UocRu.js((Object)convertInspOrderDo, UocInspOrderItem.class));
    }

    public void modifyItemRemainCountReduce(UocInspOrderDo convertInspOrderDo) {
        this.uocInspOrderItemMapper.modifyItemRemainCountReduce((UocInspOrderItem)UocRu.js((Object)convertInspOrderDo, UocInspOrderItem.class));
    }

    public void updateInspRemark(UocInspOrderDo convertInspOrderDo) {
        UocInspOrderPo set = new UocInspOrderPo();
        set.setRemark(convertInspOrderDo.getRemark());
        set.setUpdateTime(new Date());
        UocInspOrderPo where = new UocInspOrderPo();
        where.setOrderId(convertInspOrderDo.getOrderId());
        where.setInspOrderId(convertInspOrderDo.getInspOrderId());
        this.uocInspOrderMapper.updateBy(set, where);
    }

    private void syncSaleEs(List<UocInspOrderPo> listPage) {
        ArrayList<SyncEsRunnableBo> syncEsRunnableBoList = new ArrayList<SyncEsRunnableBo>();
        for (UocInspOrderPo uocSaleOrderPo : listPage) {
            SyncEsRunnableBo signleSync = new SyncEsRunnableBo();
            signleSync.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            signleSync.setOrderId(uocSaleOrderPo.getOrderId());
            signleSync.setObjId(uocSaleOrderPo.getInspOrderId());
            signleSync.setIndexName(this.uocIndexConfig.getInspOrderIndex());
            syncEsRunnableBoList.add(signleSync);
        }
        this.uocThreadPool.executeRunnable((Runnable)new UocSyncEsRunnable(syncEsRunnableBoList));
    }
}

