package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocConfButtonPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocConfButtonMapper
 * 说明:订单按钮配置表
 * 时间:2022-04-07 20:52
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocConfButtonMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocConfButtonPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocConfButtonPo uocConfButtonPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocConfButtonPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocConfButtonPo uocConfButtonPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set   set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocConfButtonPo set, @Param("where") UocConfButtonPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocConfButtonPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocConfButtonPo uocConfButtonPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocConfButtonPo 参数对象
	 * @return UocConfButtonPo 结果对象
	 */
	UocConfButtonPo getModelBy(UocConfButtonPo uocConfButtonPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocConfButtonPo 参数对象
	 * @return List<UocConfButtonPo> 结果对象
	 */
	List<UocConfButtonPo> getList(UocConfButtonPo uocConfButtonPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocConfButtonPo 参数对象
	 * @param page            分页参数
	 * @return List<UocConfButtonPo> 结果对象
	 */
	List<UocConfButtonPo> getListPage(UocConfButtonPo uocConfButtonPo, Page<UocConfButtonPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocConfButtonPo> list);

}
