package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.repository.po.UocSaleOrderMapPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocSaleOrderMapMapper
 * 说明:销售单扩展表
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocSaleOrderMapMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocSaleOrderMapPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocSaleOrderMapPo uocSaleOrderMapPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocSaleOrderMapPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocSaleOrderMapPo uocSaleOrderMapPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocSaleOrderMapPo set, @Param("where") UocSaleOrderMapPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocSaleOrderMapPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocSaleOrderMapPo uocSaleOrderMapPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocSaleOrderMapPo 参数对象
	 * @return UocSaleOrderMapPo 结果对象
	 */
	UocSaleOrderMapPo getModelBy(UocSaleOrderMapPo uocSaleOrderMapPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocSaleOrderMapPo 参数对象
	 * @return List<UocSaleOrderMapPo> 结果对象
	 */
	List<UocSaleOrderMapPo> getList(UocSaleOrderMapPo uocSaleOrderMapPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocSaleOrderMapPo 参数对象
	 * @param page 分页参数
	 * @return List<UocSaleOrderMapPo> 结果对象
	 */
	List<UocSaleOrderMapPo> getListPage(UocSaleOrderMapPo uocSaleOrderMapPo, Page<UocSaleOrderMapPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocSaleOrderMapPo> list);

	void updateBatchValue(@Param("list") List<UocSaleOrderMapPo> uocSaleOrderMapPoList, @Param("uocSaleOrderMapPo") UocSaleOrderMapPo uocSaleOrderMapPo);

	void updateInvalid(UocSaleOrderMapPo uocSaleOrderMapPo);
}
