package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocConfInspectionPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocConfInspectionMapper
 * 说明:订单验收配置表
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocConfInspectionMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocConfInspectionPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocConfInspectionPo uocConfInspectionPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocConfInspectionPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocConfInspectionPo uocConfInspectionPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocConfInspectionPo set, @Param("where") UocConfInspectionPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocConfInspectionPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocConfInspectionPo uocConfInspectionPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocConfInspectionPo 参数对象
	 * @return UocConfInspectionPo 结果对象
	 */
	UocConfInspectionPo getModelBy(UocConfInspectionPo uocConfInspectionPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocConfInspectionPo 参数对象
	 * @return List<UocConfInspectionPo> 结果对象
	 */
	List<UocConfInspectionPo> getList(UocConfInspectionPo uocConfInspectionPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocConfInspectionPo 参数对象
	 * @param page 分页参数
	 * @return List<UocConfInspectionPo> 结果对象
	 */
	List<UocConfInspectionPo> getListPage(UocConfInspectionPo uocConfInspectionPo, Page<UocConfInspectionPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocConfInspectionPo> list);

}
