package com.tydic.dyc.oc.repository.po;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

 //import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * uoc_check_order
 * @author 
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocCheckOrderPo implements Serializable {
    /**
     * 对账id
     */
    private Long checkId;

    /**
     * 对账类型：
            1：订单创建对账
            2：订单妥投对账
            3：订单拒收对账
            4：订单售后完成对账
     */
    private Integer checkType;

    /**
     * 对账类型描述
     */
    private String checkTypeDesc;

    /**
     * 对账数量结果：
            1：一致
            2：不一致
     */
    private Integer checkAmountResult;

    /**
     * 对账数量结果描述
     */
    private String checkAmountResultDesc;

    /**
     * 对账数量结果：
            1：一致
            2：不一致
     */
    private Integer checkMoneyResult;

    /**
     * 对账金额结果描述
     */
    private String checkMoneyResultDesc;

    /**
     * 内部订单数量
     */
    private Integer internalOrderAmount;

    /**
     * 电商订单数量
     */
    private Integer outOrderAmount;

    /**
     * 内部订单金额
     */
    private BigDecimal internalOrderPrice;

    /**
     * 电商订单金额
     */
    private BigDecimal outOrderPrice;

    /**
     * 对账日
     */
    private Date checkDate;

    /**
     * 对账执行时间
     */
    private Date executeTime;

    /**
     * 供应商:
            JD:京东
            SN:苏宁
            STB:史泰博
            LXWL:领先未来
            DL:得力
     */
    private String supplier;

    private static final long serialVersionUID = 1L;

     //@DocField(value = "归档表后缀")
    private String dataAchiveTabSuffix;
}
