package com.tydic.dyc.oc.repository.po;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

 //import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * uoc_out_check_order
 * @author 
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocOutCheckOrderPo implements Serializable {
    
    private static final long serialVersionUID = -656437365960871290L;
    /**
     * ID
     */
    private Long id;

    /**
     * 电商订单id
     */
    private String outOrderId;

    /**
     * 电商订单状态
     */
    private Integer outOrderState;

    /**
     * 是否挂起
     */
    private Integer hangUpState;

    /**
     * 电商订单金额
     */
    private BigDecimal outOrderPrice;

    /**
     * 电商订单时间
     */
    private Date outOrderTime;

    /**
     * 供应商:
            JD:京东
            SN:苏宁
            STB:史泰博
            LXWL:领先未来
            DL:得力
     */
    private String supplier;
    
    /**
     * 对账类型:
     1：订单创建对账
     2：订单妥投对账
     3：订单拒收对账
     4：订单售后完成对账',
     */
    private Integer checkType;
    
    //订单时间开始
    private Date orderTimeStart;
    
    //订单时间结束
    private Date orderTimeEnd;
     //@DocField(value = "归档表后缀")
    private String dataAchiveTabSuffix;
}
