package com.tydic.dyc.oc.repository.po;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocOrderItemPo
 * 说明:销售订单明细
 * 时间:2022-04-08 10:54
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocOrderItemPo implements Serializable {
	private static final long serialVersionUID = 538940257263303839L;

	//订单明细id")
	private Long orderItemId;

	//订单id")
	private Long orderId;

	//明细类型             1 商品sku             2 物资             3 项目")
	private Integer itemType;

	//明细状态")
	private String orderItemState;

	//商品id")
	private String commodityId;

	//商品编码")
	private String commodityCode;

	//商品名称")
	private String commodityName;

	//商品类型ID")
	private String commodityTypeId;

	//商品类型名称")
	private String commodityTypeName;

	//外部单品ID")
	private String extSkuId;

	//单品ID")
	private String skuId;

	//单品名称")
	private String skuName;

	//单品编码")
	private String skuCode;

	//供应商ID")
	private String supplierId;

	//供应商名称")
	private String supplierName;

	//店铺ID")
	private String supplierShopId;

	//店铺名称")
	private String supplierShopName;

	//销售金额")
	private BigDecimal saleFee;

	//采购金额")
	private BigDecimal purchaseFee;

	//单品来源      1 自营单品   2 电商导入   3 协议生成    ")
	private Integer skuSource;

	//采购金额")
	private BigDecimal purchasePrice;

	//采购金额")
	private BigDecimal salePrice;

	//采购数量")
	private BigDecimal purchaseCount;

	//运费")
	private BigDecimal transFee;

	//应付金额")
	private BigDecimal payFee;

	//积分优惠金额")
	private BigDecimal integralDisFee;

	//活动优惠金额")
	private BigDecimal actDisFee;

	//其它优惠金额")
	private BigDecimal otherDisFee;

	//实付金额")
	private BigDecimal usedFee;

	//实付积分")
	private BigDecimal usedIntegral;

	//币种")
	private String currencyType;

	//税金")
	private String taxPrice;

	//税率")
	private String tax;

	//预计发货时间")
	private Date preSendTime;

	//预计发货时间 开始")
	private Date preSendTimeStart;

	//预计发货时间 结束")
	private Date preSendTimeEnd;

	//预计交货时间")
	private Date preOfferTime;

	//预计交货时间 开始")
	private Date preOfferTimeStart;

	//预计交货时间 结束")
	private Date preOfferTimeEnd;

	//计量单位")
	private String unitName;

	//结算计量单位")
	private String settleUnit;

	//外部电商主订单id")
	private String imOrderId;

	//外部电商子订单id")
	private String imSubOrderId;

	//到货周期")
	private String arrivalTime;

	//加价率")
	private Double markUpRate;

	//商品服务费 ")
	private String serPrice;

	//计划id")
	private String planId;

	//计划明细id")
	private String planItemId;

	//计划编号")
	private String planNo;

	//计划明细编号")
	private String planItemNo;

	//协议id")
	private String agreementId;

	//协议编号")
	private String agreementNo;

	//协议模式 1：平台协议 2：单位协议")
	private Integer agreementCode;

	//超验百分比，下单时保存（协议、无协议）")
	private Integer inspectionExcessPercent;

	//税务编码")
	private String taxId;

	//创建时间")
	private Date createTime;

	//创建时间 开始")
	private Date createTimeStart;

	//创建时间 结束")
	private Date createTimeEnd;

	//创建工号")
	private String createOperId;

	//更新时间")
	private Date updateTime;

	//更新时间 开始")
	private Date updateTimeStart;

	//更新时间 结束")
	private Date updateTimeEnd;

	//更新工号")
	private String updateOperId;

	//备注")
	private String remark;

	//sku物料id")
	private String skuMaterialId;

	//sku物料编码")
	private String skuMaterialCode;

	//sku外部单品id")
	private String skuExtSkuId;

	//sku品牌id")
	private Long skuBrandId;

	//单品品牌名称")
	private String skuBrandName;

	//sku明细id")
	private String skuItemId;

	//sku物料名称")
	private String skuMaterialName;

	//sku物料类型名称")
	private String skuMaterialTypeName;

	//sku物料类型id")
	private String skuMaterialTypeId;

	//型号")
	private String model;

	//规格")
	private String spec;

	//材质")
	private String texture;

	//图号")
	private String figure;

	//一级类目")
	private Long l1Catalog;

	//二级类目")
	private Long l2Catalog;

	//三级类目")
	private Long l3Catalog;

	//一级类目名称")
	private String l1CatalogName;

	//二级类目名称")
	private String l2CatalogName;

	//三级类目名称")
	private String l3CatalogName;

	//退货时间，空代表不支持")
	private Integer rejectAllowDate;

	//换货时间，空代表不支持")
	private Integer exchangeAllowDate;

	//维修时间，空代表不支持")
	private Integer maintainAllowDate;

	//sku单品主图url")
	private String skuMainPicUrl;

	//扩展字段")
	private String extField1;

	//扩展字段")
	private String extField2;

	//扩展字段")
	private String extField3;

	//扩展字段")
	private String extField4;

	//扩展字段")
	private String extField5;

	//扩展字段")
	private String extField6;

	//扩展字段")
	private String extField7;

	//扩展字段")
	private String extField8;

	//扩展字段")
	private String extField9;

	//扩展字段")
	private String extField10;

	//删除标志1已删除")
	private Integer delTag;

	//排序")
	private String orderBy;

	//计量单位位数")
	private String unitDigit;
	 //@DocField(value = "归档表后缀")
	private String dataAchiveTabSuffix;
}
