var util = (function() {
    var ajax = function(data) {
        var serviceUrl = projectName + '/pay/rest' + data.params.service;
        var contentType = 'application/x-www-form-urlencoded;charset=UTF-8';
        if (data.contentType === 'json') {
            contentType = 'application/json;charset=UTF-8';
            data.params = JSON.stringify(data.params || {});
        }
        $.ajax({
            type: data.type ? data.type : 'POST',
            url: data.url ? data.url : serviceUrl,
            data: data.params || {},
            cache: data.cache ? true : false,
            dataType: data.dataType ? data.dataType : 'json',
            async: data.async != undefined ? data.async :true,
            contentType: contentType,
            traditional: true,
            success: function(returnData) {
                console.log(returnData);
                var payOrderMsg = "";
                if(returnData.respDesc != null && returnData.respDesc != ""){
                    var returnMsg = returnData.respDesc;
                    payOrderMsg = returnMsg.substring(returnMsg.lastIndexOf("：")+1);
                }
                if (data.loadingHide != false) {
                    hideLoadingMask();
                }
                var rspCode = data.rspCode || '0000';
                if (returnData.rspCode == rspCode) {
                    if (data.successF) {
                        data.successF(returnData);//请求成功
                    } else {
                        util.dialog.alert(returnData.rspName || '操作成功');
                    }
                } else {
                    if(data.failF){
                        data.failF(returnData);//请求接口成功，但状态码不正确
                    }else{
                        util.dialog.alert(returnData.rspName || payOrderMsg || '系统繁忙');
                    }
                }
            },
            error: function(XMLHttpRequest, textStatus, errorThrown) {
                if (data.loadingHide != false) {
                    hideLoadingMask();
                }
                if (data.errorF) {
                    data.errorF(XMLHttpRequest, textStatus, errorThrown);
                } else {
                    //调用提示框组件，提示失败，在平台开发的时候进行补充
                    util.dialog.alert('网络异常');
                }
            }
        });
    };
    var getQueryString = function(name) {
        var reg = new RegExp('(^|&)' + name + '=([^&]*)(&|$)', 'i'); // 匹配目标参数
        var result = window.location.search.substr(1).match(reg); // 对querystring匹配目标参数
        if (result != null) {
            return decodeURIComponent(result[2]);
        } else {
            return null;
        }
    };
    var dialog = {
        // 层叠顺序z-index
        _zIdx: 3000,
        /*
         * 提示框
         * message: String 文本的显示内容
         * title: String 标题的显示内容
         * btnValue: String 按钮的显示内容
         * callback: Function 按钮的回调函数
         */
        alert: function(message, title, btnValue, callback) {
            if (typeof message === 'undefined') {
                message = '';
                title = '提示';
                btnValue = '确 定';
            } else if (typeof title === 'undefined') {
                title = '提示';
                btnValue = '确 定';
            } if (typeof title === 'function') {
                callback = title;
                title = '提示';
                btnValue = '确 定';
            } else if (typeof btnValue === 'function') {
                callback = btnValue;
                btnValue = '确 定';
            }
            var dialogLayer = $('<div class="dialog-layer">'
                + '<div class="bg-cover" style="z-index:' + this._zIdx++ + '"></div>'
                + '<div class="dialog-box" style="z-index:' + this._zIdx++ + '">'
                + '<div class="dialog-top"><span class="dialog-title">' + title + '</span></div>'
                + '<div class="dialog-middle"><span class="middle-align-bar"></span><span class="dialog-message">' + message + '</span></div>'
                + '<div class="dialog-bottom"><div class="btn btn-ok" data-name="okBtn">' + btnValue + '</div></div>'
                + '</div>'
                + '</div>');
            $('body').append(dialogLayer);

            // [确定]按钮绑定点击事件
            dialogLayer.find('[data-name="okBtn"]').bind('click', function() {
                if (callback && callback != null) {
                    callback();
                }
                dialogLayer.remove();
            });
        },
        /*
         * 确认框
         * message: String 文本的显示内容
         * title: String 标题的显示内容
         * btnArray: Array 按钮的显示内容，下标0：第一个按钮，下标1：第二个按钮
         * callback: Function 按钮的回调函数，index=0：第一个按钮的回调函数，index=1：第二个按钮的回调函数
         */
        confirm: function(message, title, btnArray, callback) {
            if (typeof message === 'undefined') {
                message = '';
                title = '提示';
                btnArray = ['确 定', '取 消'];
            } else if (typeof title === 'undefined') {
                title = '提示';
                btnArray = ['确 定', '取 消'];
            } if (typeof title === 'function') {
                callback = title;
                title = '提示';
                btnArray = ['确 定', '取 消'];
            } else if (typeof btnArray === 'function') {
                callback = btnArray;
                btnArray = ['确 定', '取 消'];
            }
            var dialogLayer = $('<div class="dialog-layer">'
                + '<div class="bg-cover" style="z-index:' + this._zIdx++ + '"></div>'
                + '<div class="dialog-box" style="z-index:' + this._zIdx++ + '">'
                + '<div class="dialog-top"><span class="dialog-title">' + title + '</span></div>'
                + '<div class="dialog-middle"><span class="middle-align-bar"></span><span class="dialog-message">' + message + '</span></div>'
                + '<div class="dialog-bottom"><div class="btn btn-ok" data-name="okBtn">' + btnArray[0] + '</div><div class="btn btn-cancel" data-name="cancelBtn">' + btnArray[1] + '</div></div>'
                + '</div>'
                + '</div>');
            $('body').append(dialogLayer);

            // [确定]按钮绑定点击事件
            dialogLayer.find('[data-name="okBtn"]').bind('click', function() {
                if (callback && callback != null) {
                    callback({index: 0});
                }
                dialogLayer.remove();
            });
            // [取消]按钮绑定点击事件
            dialogLayer.find('[data-name="cancelBtn"]').bind('click', function() {
                if (callback && callback != null) {
                    callback({index: 1});
                }
                dialogLayer.remove();
            });
        }
    };
    var countdown = function(el, diffTime, callback) {
        var rDate = {};
        rDate.days = Math.floor(diffTime / (24 * 3600 * 1000));
        var leave1 = diffTime % (24 * 3600 * 1000);
        rDate.hours = Math.floor(leave1 / (3600 * 1000));
        var leave2 = leave1 % (3600 * 1000);
        rDate.minutes = Math.floor(leave2 / (60 * 1000));
        var leave3 = leave2 % (60 * 1000);
        rDate.seconds = Math.round(leave3 / 1000);

        var rHours = rDate.hours + '小时',
            rMinutes = rDate.minutes + '分钟',
            rSeconds = rDate.seconds + '秒';
        if (rDate.hours == 0) {
            rHours = '';
            if (rDate.minutes == 0) {
                rMinutes = '';
            }
        }
        $(el).text(rHours + rMinutes + rSeconds);

        if (callback && typeof callback === 'function') {
            callback(diffTime);
        }
        if (diffTime <= 0) {
            return;
        }
        setTimeout(function() {
            util.countdown(el, diffTime - 1000, callback);
        }, 1000);
    };
    var utf16to8 = function(str) {
        var out, i, len, c;
        out = '';
        len = str.length;
        for(i = 0; i < len; i++) {
            c = str.charCodeAt(i);
            if ((c >= 0x0001) && (c <= 0x007F)) {
                out += str.charAt(i);
            } else if (c > 0x07FF) {
                out += String.fromCharCode(0xE0 | ((c >> 12) & 0x0F));
                out += String.fromCharCode(0x80 | ((c >>  6) & 0x3F));
                out += String.fromCharCode(0x80 | ((c >>  0) & 0x3F));
            } else {
                out += String.fromCharCode(0xC0 | ((c >>  6) & 0x1F));
                out += String.fromCharCode(0x80 | ((c >>  0) & 0x3F));
            }
        }
        return out;
    };

    return {
        ajax: ajax,
        getQueryString: getQueryString,
        dialog: dialog,
        countdown: countdown,
        utf16to8: utf16to8
    };
})();

// 对Date的扩展，将 Date 转化为指定格式的String
// 月(M)、日(d)、小时(h)、分(m)、秒(s)、季度(q) 可以用 1-2 个占位符，
// 年(y)可以用 1-4 个占位符，毫秒(S)只能用 1 个占位符(是 1-3 位的数字)
// 例子：
// (new Date()).Format("yyyy-MM-dd hh:mm:ss.S") ==> 2006-07-02 08:09:04.423
// (new Date()).Format("yyyy-M-d h:m:s.S")   ==> 2006-7-2 8:9:4.18
Date.prototype.Format = function (fmt) { //author: meizz
    var o = {
        "M+": this.getMonth() + 1, //月份
        "d+": this.getDate(), //日
        "h+": this.getHours(), //小时
        "m+": this.getMinutes(), //分
        "s+": this.getSeconds(), //秒
        "q+": Math.floor((this.getMonth() + 3) / 3), //季度
        "S": this.getMilliseconds() //毫秒
    };
    if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
    for (var k in o)
        if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
    return fmt;
};
