var projectInfo = undefined;
var payOrderInfo = JSON.parse(sessionStorage.getItem('payOrderInfo'));
if (!payOrderInfo) {
    payOrderInfo = {
        orderId: util.getQueryString('orderId')
    };
} else {
    payOrderInfo.orderId = util.getQueryString('orderId');
}

$(document).ready(function () {
    getProjectInfo();
    qryPayInfo();
    $('#couponBox').on('keyup', '#usedBalance', function (e) {
        var $this = $(this);
        var $cover = $('#paymentList .disable-cover');
        if (parseFloat($this.val()) >= parseFloat(payOrderInfo.totalFee)) {
            if ($cover.length > 0) {
                return;
            }
            $('#paymentList').append("<div class='disable-cover'><div class='disable-content'>无需选择支付方式</div></div>");
            $('#paymentList .payment-mode').removeClass('checked');
        } else {
            $cover.remove();
        }
    });
    $('#paymentList').on('click', '.payment-mode', function (e) {
        var $this = $(this);
        $this.addClass('checked').siblings().removeClass('checked');
    });
    $('#payNow').on('click', function () {
        //若有红包信息
        if (payOrderInfo.totalBalance > 0) {
            if (!getDiscountInfo()) {
                return;
            }
        }
        //若需支付金额与使用电子券金额相等，则立即支付，无需选择支付方式
        if (payOrderInfo.usedBalance === payOrderInfo.totalFee) {
            payNow();
            return;
        }
        var payMethodObj = $('#paymentList .payment-mode.checked');
        payOrderInfo.payMethod = payMethodObj.data('pay-method');
        if (payOrderInfo.payMethod == '24') {
            aliPcWebPay();
        } else if (payOrderInfo.payMethod == '30') {
            cashPay();
        } else if (payOrderInfo.payMethod == '54') {
            getWopayInfo();
        } else if (payOrderInfo.payMethod == '1') {
            misposPay();
        } else {
            sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
            window.location.href = payMethodObj.data('url');
        }
    });
});

var getProjectInfo = function () {
    var data = {};
    data.params = {};
    data.params.service = "getConfigInfosFunctionService";
    data.async = false;
    data.successF = function (returnData) {
        projectInfo = {
            payAccessIp: returnData.payAccessIp,
            payAccessProjectName: returnData.payAccessProjectName,
            payContactIp: returnData.payContactIp,
            payContactProjectName: returnData.payContactProjectName
        };
        sessionStorage.setItem('projectInfo', JSON.stringify(projectInfo));
    };
    util.ajax(data);
};

var qryPayInfo = function () {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId
    };
    data.params.service = 'paymentMethodInquiryService';
    data.successF = function (returnData) {
        $('#orderId').text(returnData.orderId);
        $('#totalFee').text(returnData.totalFee.indexOf('.') >= 0 ? returnData.totalFee : returnData.totalFee + '.00');
        util.countdown('#remainingTime', returnData.payTimeLeft, function (timeLeft) {
            if (timeLeft <= 0) {
                util.dialog.alert('订单已超时，点击确定返回重新下单', function () {
                    window.history.back();
                });
            }
        });
        payOrderInfo.orderId = returnData.orderId;
        payOrderInfo.totalFee = returnData.totalFee;
        payOrderInfo.createTime = returnData.createTime;
        payOrderInfo.redirectUrl = returnData.redirectUrl;

        var paymentList = '';
        $.each(returnData.payMethod, function (i, item) {
            if (item.payMethod == '2' || item.payMethod == '3' ||
                item.payMethod == '4' || item.payMethod == '5' || item.payMethod == '6') {
                return;
            }
            var iconClass = '';
            var dataUrl = '';
            switch (Number(item.payMethod)) {
                case 10:
                    iconClass = 'pay-weixin-barcode';
                    dataUrl = 'payWeixinBarCode.html';
                    break;
                case 11:
                    iconClass = 'pay-weixin-qrcode';
                    dataUrl = 'payWeixinQrCode.html';
                    break;
                case 20:
                    iconClass = 'pay-zhifubao-barcode';
                    dataUrl = 'payZhifubaoBarCode.html';
                    break;
                case 21:
                    iconClass = 'pay-zhifubao-qrcode';
                    dataUrl = 'payZhifubaoQrCode.html';
                    break;
                case 24:
                    iconClass = 'pay-alipay';
                    break;
                case 30:
                    iconClass = 'pay-cashPay';
                    break;
                case 54:
                    iconClass = 'pay-wopay';
                    break;
                case 1:
                    iconClass = 'pay-misPosPay';
                    break;
            }
            paymentList += '<div class=" payment-mode ' + iconClass + '' + (i == 0 ? " checked" : "") + '" data-pay-method="' + item.payMethod + '" data-pay-type="' + item.payType + '" data-url="' + dataUrl + '">' +
                '<i></i>' +
                '</div>';
        });
        $('#paymentList').html(paymentList);

        // 如果只有mispos一种支付方式，就直接打开mispos支付界面
        if (returnData.payMethod.length == 6 && returnData.payMethod[0].payMethod == '1') {
            payOrderInfo.payMethod = returnData.payMethod[0].payMethod;
            misposPay();
        } else {
            qryElectronCoupon();
        }
    };
    loadingMask('正在查询支付信息...');
    util.ajax(data);
};

/**
 * 查询电子券信息
 */
var qryElectronCoupon = function () {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId
    };
    data.params.service = 'queryElectronCouponBalanceCombService';
    data.successF = function (returnData) {
        $('.view-main').show();
        var currBalance = returnData.currBalance;
        if (isEmpty(currBalance)) {
            return;
        }
        var phoneNo = returnData.serialNumber;
        payOrderInfo.totalBalance = currBalance;
        payOrderInfo.userMobile = phoneNo;
        var electronCouponHtml = '<div class="pay-title">' +
            '<div class="order-tip">使用电子券</div>' +
            '</div>' +
            '<div class="pay-type clearfix">' +
            '<div class="pay-row">' +
            '<span class="pay-label">手机号码：</span>' +
            '<span id="phoneNo" class="pay-text">' + phoneNo + '</span>' +
            '</div>' +
            '<div class="pay-row">' +
            '<input type="checkbox" class="pay-checkbox" id="payCheckbox" checked/>' +
            '<label class="pay-label" for="payCheckbox">使用电子券</label>' +
            '<span class="pay-label">（电子券当前余额：<span id="currBalance" class="color-red">' + (currBalance.indexOf('.') >= 0 ? currBalance : currBalance + '.00') + '</span>元）</span>' +
            '</div>' +
            '<div class="pay-row">' +
            '<span class="pay-label ticket-fee">本次使用<input type="text" id="usedBalance" class="pay-input"/>元</span>' +
            '<span class="pay-label ticket-pwd">电子券密码<input type="password" id="ticketPwd" class="pay-input"/></span>' +
            '</div>' +
            '</div>';
        $('#couponBox').empty().append(electronCouponHtml);
    };
    data.failF = function (returnData) {
        $('.view-main').show();
        if (returnData.rspCode == "9999") {
            console.log(returnData.rspName || "未配置红包商户");
        } else {
            console.log(returnData.rspName || "查询电子券失败");
        }
    };
    loadingMask("正在查询电子券信息...");
    util.ajax(data);
};

/**
 * 校验并获取优惠信息
 */
var getDiscountInfo = function () {
    if ($("#payCheckbox").is(':checked')) {
        var usedBalance = $("#usedBalance").val();
        var usedBalanceNo = parseFloat(usedBalance);
        var totalBalance = parseFloat(payOrderInfo.totalBalance);
        var totalFee = parseFloat(payOrderInfo.totalFee);
        var ticketPwd = $("#ticketPwd").val();
        var reg = /^\d+(\.\d{1,2})?$/;
        if (isEmpty(usedBalance)) {
            util.dialog.alert("请输入使用电子券金额");
            return false;
        } else if (!reg.test(usedBalanceNo) || usedBalanceNo < 0.01 ||
            usedBalanceNo > totalBalance || usedBalanceNo > totalFee) {
            util.dialog.alert("使用电子券金额输入不正确");
            return false;
        } else if (isEmpty(ticketPwd)) {
            util.dialog.alert("请输入电子券密码");
            return false;
        } else {
            payOrderInfo.usedBalance = usedBalance;
            payOrderInfo.passWord = ticketPwd;
            return true;
        }
    } else {
        return true;
    }
};
/**
 * 需支付金额与使用电子券金额相等时，立即支付
 */
var payNow = function () {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        totalFee: payOrderInfo.totalFee,
        userMobile: payOrderInfo.userMobile,
        usedBalance: payOrderInfo.usedBalance,
        totalBalance: payOrderInfo.totalBalance,
        passWord: payOrderInfo.passWord
    };
    data.params.service = "aggregationPayCombService";
    data.successF = function (returnData) {
        sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
        location.replace('payResult.html?payStatus=' + returnData.payStatus + "&rspName=" + returnData.rspName);
    };
    loadingMask("等待支付结果...");
    util.ajax(data);
};
/**
 * 现金支付
 */
var cashPay = function () {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        totalFee: payOrderInfo.totalFee,
        payMethod: payOrderInfo.payMethod
    };
    //若使用电子券
    if (payOrderInfo.usedBalance) {
        data.params.userMobile = payOrderInfo.userMobile;
        data.params.usedBalance = payOrderInfo.usedBalance;
        data.params.totalBalance = payOrderInfo.totalBalance;
        data.params.passWord = payOrderInfo.passWord;
        data.params.service = "aggregationPayCombService";
    } else {
        data.params.service = "pmcUniPayIntfceService";
    }
    data.successF = function (returnData) {
        sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
        location.replace('payResult.html?payStatus=SUCCESS');
    };
    loadingMask('现金支付确认中...');
    util.ajax(data);
};

/**
 * 支付宝H5支付
 */
var aliPcWebPay = function () {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        totalFee: payOrderInfo.totalFee,
        payMethod: payOrderInfo.payMethod
    };
    //若使用电子券
    if (payOrderInfo.usedBalance) {
        data.params.userMobile = payOrderInfo.userMobile;
        data.params.usedBalance = payOrderInfo.usedBalance;
        data.params.totalBalance = payOrderInfo.totalBalance;
        data.params.passWord = payOrderInfo.passWord;
        data.params.service = "aggregationPayCombService";
    } else {
        data.params.service = "pmcUniPayIntfceService";
    }
    data.successF = function (returnData) {
        sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
        var form = $(returnData.body).appendTo('html');
    };
    loadingMask('正在跳转支付宝...');
    util.ajax(data);
};

/**
 * 沃支付
 */
var getWopayInfo = function () {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        payMethod: payOrderInfo.payMethod,
        addStr: projectInfo.payAccessIp + projectInfo.payAccessProjectName
    };
    data.params.service = 'queryWopayInternetArgService';
    data.successF = function (returnData) {
        sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
        var form = $('<form action="' + returnData.postUrl + '" method="post" id="wopayInternetForm"></form>').appendTo('body');
        $.each(returnData.argBo, function (key, val) {
            form.append('<input type="hidden" name="' + key + '" id="' + key + '" value="' + (val ? val : '') + '" />');
        });
        form.submit();
    };
    loadingMask('正在跳转沃支付...');
    util.ajax(data);
};

/**
 * mispos支付测试方法
 */
var misposPayTest = function () {
    if (!CIcCardCtrl.object) {
        util.dialog.alert('控件加载失败!');
        return;
    }
    var jsonParam = {
        'BUSI_AMT': '1', // Y 交易金额 单位：分
        'BUSI_TRANS_TYPE': 'Consume', // Y 交易类型
        'BUSI_CONSTRACT_CELLNO': '9900', // Y 业务受理号码(批量受理时以第一笔受理号码为准；小系统以单号为准，供后期在资金系统查询交易明细时使用)
        'BUSI_SYS': 'D400', // Y 业务系统编码，以全业务渠道编码为准
        'ORIGINAL_BUSI_ORDER_ID': '', // 原始订单号
        'ORIGINAL_TRANS_TYPE': '', // 原始交易类型
        'BUSI_ORDER_ID': '99000001' + new Date().Format('yyyyMMddhhmmssS') + new Date().Format('S'), // Y 业务侧支付订单号(必选 消费/撤销/退货) 例：'9900000120151128002001849955'
        'BUSI_TM': new Date().Format('yyyyMMddhhmmss'), // Y 业务系统交易发生时间
        'BUSI_TYPE': '1', // Y 业务类型（1:营业/2:账管/3:资源/4:购物车）
        'BUSI_NODE_ID': '13a0164', // Y 营业厅编号（总部渠道编码）
        'BUSI_STAFF_ID': 'LTHQY211', // Y 营业员工号
        'BUSI_NODE_PRO': '13', // Y 业务发生省份编码
        'BUSI_NODE_CITY': '130', // Y 业务发生地市编码
        'BUSI_NODE_AREA': '132006', // N 业务发生区县编码
        'BUSI_CELLNO': '' // N 业务办理手机号(电子签名短信下发使用)
    };
    var misposBackData = CIcCardCtrl.PosConsume(JSON.stringify(jsonParam));
    alert(misposBackData);
};

/**
 * mispos支付
 */
var misposPay = function () {
    if (!CIcCardCtrl.object) {
        util.dialog.alert('控件加载失败!');
        return;
    }

    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        totalFee: payOrderInfo.totalFee,
        payMethod: payOrderInfo.payMethod
    };
    //若使用电子券
    if (payOrderInfo.usedBalance) {
        data.params.userMobile = payOrderInfo.userMobile;
        data.params.usedBalance = payOrderInfo.usedBalance;
        data.params.totalBalance = payOrderInfo.totalBalance;
        data.params.passWord = payOrderInfo.passWord;
        data.params.service = "aggregationPayCombService";
    } else {
        data.params.service = "pmcUniPayIntfceService";
    }
    data.successF = function (returnData) {
        var misposBackData = CIcCardCtrl.PosConsume(returnData.data);
        misposBackData = JSON.parse(misposBackData);
        // TRANS_STATUS: 00 支付成功，01 支付失败， 02 支付超时
        if (misposBackData.TRANS_STATUS == '00') {
            misposPayBack(misposBackData, 'SUCCESS');
        } else if (misposBackData.TRANS_STATUS == '01') {
            misposPayBack(misposBackData, 'FAIL');
        } else if (misposBackData.TRANS_STATUS == '02') {
            misposSearch(returnData.payOrderId);
        }
    };
    loadingMask('正在跳转MisPos支付...');
    util.ajax(data);
};

/**
 * 支付成功/失败，调用更新接口
 * @param misposBackData mispos消费的返回数据
 */
var misposPayBack = function (misposBackData, payStatus) {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        data: JSON.stringify(misposBackData)
    };
    data.params.service = 'pmcMisposPayBackBusiService';
    data.successF = function (returnData) {
        sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
        location.replace('payResult.html?payStatus=' + payStatus);
    };
    loadingMask('正在更新支付结果...');
    util.ajax(data);
};

/**
 * 支付超时，调用查询接口
 * @param payOrderId 支付订单号
 */
var misposSearch = function (payOrderId) {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        payOrderId: payOrderId
    };
    data.params.service = 'pmcMisposSearchBusiService';
    data.successF = function (returnData) {
        var misposBackData = CIcCardCtrl.PosSerach(returnData.data);
        misposBackData = JSON.parse(misposBackData);
        // TRANS_STATUS: 00 支付成功，01 支付失败， 02 支付超时
        if (misposBackData.TRANS_STATUS == '00') {
            misposSearchBack(misposBackData, 'SUCCESS');
        } else if (misposBackData.TRANS_STATUS == '01') {
            misposSearchBack(misposBackData, 'FAIL');
        } else if (misposBackData.TRANS_STATUS == '02') {
            misposSearch(returnData.payOrderId);
        }
    };
    loadingMask('支付超时，正在补单...');
    util.ajax(data);
};

/**
 * 支付超时查询成功之后，调用查询返回接口
 * @param misposBackData mispos补单的返回数据
 */
var misposSearchBack = function (misposBackData, payStatus) {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        data: JSON.stringify(misposBackData)
    };
    data.params.service = 'pmcMisposSearchBackBusiService';
    data.successF = function (returnData) {
        sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
        location.replace('payResult.html?payStatus=' + payStatus);
    };
    loadingMask('正在更新支付结果...');
    util.ajax(data);
};

function showdiv(popWinId) {
    if (!window.XMLHttpRequest) {
        for (var i = 0; i < selects.length; i++) {
            if (selects[i].style.display != 'none') {
                selects_display.push(selects[i]);
                selects[i].style.display = 'none';
            }
        }
    }
    document.getElementById('bg_mask').style.display = 'block';
    document.getElementById(popWinId).style.display = 'block';
}

function hidediv(popWinId) {
    if (!window.XMLHttpRequest) {
        for (var i = 0; i < selects_display.length; i++) {
            selects_display[i].style.display = '';
        }
    }
    document.getElementById('bg_mask').style.display = 'none';
    document.getElementById(popWinId).style.display = 'none';
}