var payOrderInfo = JSON.parse(sessionStorage.getItem('payOrderInfo'));
if (!payOrderInfo) {
    payOrderInfo = {
        orderId: util.getQueryString('orderId')
    };
} else {
    payOrderInfo.orderId = util.getQueryString('orderId');
    payOrderInfo.payOrderId = util.getQueryString('payOrderId');
}

$(document).ready(function () {
    // 选择付款方式
    $('#paymentList').on('click', 'li .pay-choose', function(e) {
        var orderId = $('#orderId').text();
        var $this = $(this);
        $this.parent().parent().siblings().find('.icon-choose').removeClass('icon-choose-yes').addClass('icon-choose-no');
        $this.parent().parent().find('.icon-choose').removeClass('icon-choose-no').addClass('icon-choose-yes');
        //花呗分期
        var checkedPayMethod = $('#paymentList li .icon-choose-yes');
        var payMethodObj = checkedPayMethod.parents('li');
        payOrderInfo.payMethod = payMethodObj.data('pay-method');
        var hbDiv = '';
        var hbfqList = '';
        if(payOrderInfo.payMethod == '26'){
            var hvDivItem = '';
            $('#paymentList .hb').remove(hbDiv);
            qryTokioDivide(orderId,hvDivItem)
        }else{
            $('#paymentList .hb').remove(hbDiv);
        }
    });
    //选择花呗分期
    $('#paymentList').on('click','li .hb-item',function (e) {
        var $this = $(this);
        payOrderInfo.hbfqNum = $this.data('hbfq-num');
        console.log(payOrderInfo)
        $this.siblings().find('.hb-choose').removeClass('icon-choose-yes').addClass('icon-choose-no');
        $this.find('.hb-choose').removeClass('icon-choose-no').addClass('icon-choose-yes')
    })
    if(payOrderInfo.payOrderId && payOrderInfo.payOrderId != ''){//如果有支付订单，说明是回调回来的，直接去轮训支付状态
    	pollingPayResult();
    }else{
    	setTimeout(function() {
            qryPayInfo();//查询支付信息
        }, 300);
    }
    
    $('#payNow').on('click', function() {
        var checkedPayMethod = $('#paymentList li .icon-choose-yes');
        var payMethodObj = checkedPayMethod.parents('li');
        payOrderInfo.payMethod = payMethodObj.data('pay-method');
        if (payOrderInfo.payMethod == '13') {
            wxH5Pay();
        } else if (payOrderInfo.payMethod == '23') {
            zfbH5Pay();
        }else if (payOrderInfo.payMethod == '30') {
            cashPay();
        } else if (payOrderInfo.payMethod == '101') {
        	wopayH5Pay();
        }else if(payOrderInfo.payMethod == '113'){
            wapPay();
        } else {
            sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
            window.location.href = payMethodObj.data('url');
        }
    });

});
//花呗分期查询
var qryTokioDivide = function (orderId,hbDiv) {
    var data = {};
    data.params = {
        orderId: orderId,
        hbfqSellerPercent: '0'
    };
    data.params.service = "/aliHbfq/calculateFee";
    data.successF = function(returnData) {
        var hvDivItem = '';
        var hbfqList = returnData.data.hbfqList
        for(var i = 0;i<hbfqList.length;i++){
            hvDivItem +='<div class="hb-item pull-clearfix" data-hbfq-num="' + hbfqList[i].hbfqNum + '">' +
                        '   <div>' +
                        '    <div class="pull-left zfb">' +
                        '      <div class="fq">'+hbfqList[i].payFeePer+'元 x '+hbfqList[i].hbfqNum+'期</div>' +
                        '      <div class="hb-desc">手续费'+hbfqList[i].serviceCharge+'元/期，费率'+hbfqList[i].rate+'%</div>' +
                        '    </div>' +
                        '    <div class="pull-right mt7"><i class="hb-choose icon-choose-no"></i></div>' +
                        '   </div>' +
                        '</div>'
        }
        hbDiv +='<div class="hb center ml36 plf" id="hb">'+hvDivItem +'</div>'
        var checkedPayMethod = $('#paymentList li .icon-choose-yes');
        if(checkedPayMethod){
            checkedPayMethod.parent().parent().parent().parent().append(hbDiv);
        }
    };
    util.ajax(data);
}
var qryPayInfo = function() {
    util.loading.show('正在获取支付信息...');

    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId
    };
    data.params.service = "/cashierDesk/queryCashierDesk";
    data.successF = function(returnData) {
        var paymentList = '';
        $.each(returnData.payMethod, function(i, item) {
            var iconClass = '';
            var dataUrl = '';
            var checked = i == 0 ? 'icon-choose-yes' : 'icon-choose-no';
            switch(Number(item.payMethod)) {
                case 11:
                    iconClass='icon-wx';
                    dataUrl = 'payWeixinQrCode.html';
                    break;
                case 13:
                    iconClass='icon-wx';
                    break;
                case 21:
                    iconClass="icon-zfb";
                    dataUrl = 'payZhifubaoQrCode.html';
                    break;
                case 23:
                    iconClass="icon-zfb";
                    break;
                case 30:
                    iconClass="icon-cash";
                    break;
                case 101:
                    iconClass="icon-wo";
                    break;
                case 104:
                    iconClass="icon-wo";
                    dataUrl = 'payYimafuQrCode.html';
                    break;
                case 112://银联二维码支付
                    iconClass="icon-yl";
                    dataUrl = 'payUnionQrCode.html';
                    break;
                case 113://银联wap支付
                    iconClass="icon-yl";
                    // dataUrl = 'payUnionpayWap.html';
                    break;
                case 26://花呗支付
                    iconClass="icon-hb";
                    dataUrl = 'payTokio.html';
                    break;
            }
            paymentList +=  '<li class="relative box"  data-pay-method="' + item.payMethod + '" data-pay-type="' + item.payType + '" data-url="' + dataUrl + '">'+
                '<div  class="pull-clearfix border-box" >'+
                '  <div class="pull-left"><i class="icon ' + iconClass + ' vertical-middle"></i></div>' +
                '  <div class="center pull-clearfix ml36 pay-choose">' +
                '       <div class="pull-left zfb">' + item.payMethodName + '</div>' +
                '       <div class="pull-right"><i class="icon-choose ' + checked + '"></i></div>' +
                '  </div>' +
                '</div>'+
                '</li>';
        });
        $('#paymentList').empty().html(paymentList);

        $('#orderId').text(returnData.orderId);
        // qryTokioDivide(returnData.orderId);
        $('#goodsName').text(returnData.detailName);
        $('#totalFee').text(returnData.totalFee / 100.00);
        $('#realFee').text(returnData.realFee / 100.00);
        util.countdown('#remainingTime', returnData.payTimeLeft, function(timeLeft) {
            if (timeLeft <= 0) {
                util.dialog.alert('订单已超时，点击确定返回重新下单', function() {
                    window.history.back();
                });
            }
        });

        payOrderInfo.orderId = returnData.orderId;
        payOrderInfo.detailName = returnData.detailName;
        payOrderInfo.totalFee = returnData.totalFee;
        payOrderInfo.realFee = returnData.realFee;
        payOrderInfo.createTime = returnData.createTime;
        payOrderInfo.redirectUrl = returnData.redirectUrl;
        payOrderInfo.outOrderId = returnData.outOrderId;

        pollingPayResult();

        if (!payOrderInfo.payOrderId) {
            if (returnData.payMethod.length == 1 && returnData.payMethod[0].payMethod == '101') {
                payOrderInfo.payMethod = returnData.payMethod[0].payMethod;
                wopayH5Pay();
            }else{
                $('.view-main').show();
            }
        }
    };

    util.ajax(data);
};

//沃支付移动支付-H5支付
var wopayH5Pay = function() {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        payMethod: payOrderInfo.payMethod
    };
    data.params.service = "queryWopayMobileH5PayFunctionService";
    data.successF = function(returnData) {
        sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
    	var form = $('<form action="' + returnData.postUrl + '" method="post" id="wopayInternetForm"></form>').appendTo('body');
    	for(var k in returnData.data){
    		if(!returnData.data[k]){
    			continue;
    		}
    		form.append('<input type="hidden" name="' + k + '" value="' + returnData.data[k] + '" />');
    	}
        form.submit();
    	
    };
    util.loading.show("沃支付H5支付确认中...");
    util.ajax(data);
};

var cashPay = function() {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        totalFee: payOrderInfo.totalFee,
        realFee: payOrderInfo.realFee,
        payMethod: payOrderInfo.payMethod
    };
    data.params.service = "/pay/uniPay";
    data.successF = function(returnData) {
        sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
        // location.replace('payResult.html?payStatus=SUCCESS');
        location.href = 'payResult.html?payStatus=SUCCESS'  + "&orderId=" +  payOrderInfo.orderId;
    };
    util.loading.show("现金支付确认中...");
    util.ajax(data);
};

var wxH5Pay = function() {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        totalFee: payOrderInfo.totalFee,
        realFee: payOrderInfo.realFee,
        payMethod: payOrderInfo.payMethod
    };
    data.params.service = "/pay/uniPay";
    data.successF = function(returnData) {
        payOrderInfo.payOrderId = returnData.payOrderId;
        sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
        var curHref = location.href + '&payOrderId=' + payOrderInfo.payOrderId;

        //添加代码-start
        //回调时，查询回 支付结果页面，让微信H5支付完成跳转到支付结果页
        var resultHref = location.href.replace('cashierDesk.html','payResult.html');
        resultHref = resultHref.substring(0,resultHref.indexOf("?"));
        resultHref = resultHref + '?payStatus=SUCCESS'  + "&orderId=" +  payOrderInfo.orderId;
        console.log(resultHref);
        curHref = resultHref;
        //添加代码-end

        console.log("curHref = " + curHref);
        console.log(encodeURIComponent(curHref));
        location.href = returnData.mwebUrl + "&redirect_url=" + encodeURIComponent(curHref);
    };
    util.loading.show("正在跳转微信...");
    util.ajax(data);
};

var zfbH5Pay = function() {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        totalFee: payOrderInfo.totalFee,
        realFee: payOrderInfo.realFee,
        payMethod: payOrderInfo.payMethod
    };
    data.params.service = "/pay/uniPay";
    data.successF = function(returnData) {
        payOrderInfo.payOrderId = returnData.payOrderId;
        sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
        var form = $(returnData.body).appendTo('html');
    };
    util.loading.show("正在跳转支付宝...");
    util.ajax(data);
};

//花呗支付
/*var tokioPay = function () {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        totalFee: payOrderInfo.totalFee,
        realFee: payOrderInfo.realFee,
        payMethod: payOrderInfo.payMethod,
        hbfqNum: '3',
        hbfqSellerPercent: '0'
    };
    data.params.service = "/pay/uniPay";
    data.successF = function(returnData) {
        payOrderInfo.payOrderId = returnData.payOrderId;
        sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
        var form = $(returnData.body).appendTo('html');
    };
    util.loading.show("正在跳转花呗...");
    util.ajax(data);
}*/
//wap支付
var wapPay = function () {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        realFee: payOrderInfo.realFee,
        payMethod: payOrderInfo.payMethod
    };
    data.params.service = "/pay/uniPay";
    data.successF = function(returnData) {
        document.write(returnData.acpHtml);
        document.close();
    };
    util.ajax(data);
}

var pollingPayResult = function() {
    if (payOrderInfo.payOrderId && payOrderInfo.payOrderId !== '') {
        var payOrderId = payOrderInfo.payOrderId;
        payOrderInfo.payOrderId = null;
        sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
        timersearch = setInterval(function() {
            payWaiting(payOrderId);
        }, 1000);
    }
};

var timersearch = null;
var payTimeout = 10;
var payWaiting = function(payOrderId) {
    if (payTimeout-- > 0) {
        util.loading.show("正在查询支付结果...");
        if (payTimeout === 1) {
            qrySourcePayResult(payOrderId);
        } else {
            qryPayResult(payOrderId);
        }
    } else {
        clearInterval(timersearch);
        util.loading.hide();
        util.dialog.alert('支付已超时，请重新支付');
    }
};

var qryPayResult = function(payOrderId) {
    var data = {};
    data.loadingHide = false;
    data.params = {
        orderId: payOrderInfo.orderId,
        payOrderId: payOrderId,
        payMethod: payOrderInfo.payMethod
    };
    data.params.service = '/pay/pollingPayState';
    data.successF = function(returnData) {
        if (returnData.payStatus === 'SUCCESS') {
            clearInterval(timersearch);
            util.loading.hide();
            location.replace('payResult.html?payStatus=' + returnData.payStatus  + "&orderId=" +  payOrderInfo.orderId);
        }
    };
    data.failF = function(returnData) {

    };
    util.ajax(data);
};

var qrySourcePayResult = function(payOrderId) {
    var data = {};
    data.loadingHide = false;
    data.params = {
        orderId: payOrderInfo.orderId,
        payOrderId: payOrderId,
        payMethod: payOrderInfo.payMethod
    };
    data.params.service = '/pay/orderQuery';
    data.successF = function(returnData) {
        if (returnData.payStatus == 'SUCCESS') {
            clearInterval(timersearch);
            util.loading.hide();
            location.replace('payResult.html?payStatus=' + returnData.payStatus + "&orderId=" +  payOrderInfo.orderId);
        }
    };
    util.ajax(data);
};
