var payOrderInfo = JSON.parse(sessionStorage.getItem('payOrderInfo'));
var payOrderId = util.getQueryString('payOrderId');
var orderId= util.getQueryString('orderId');
var detailName =util.getQueryString('detailName');
var totalFee = util.getQueryString('totalFee');
var respInfo = JSON.parse(util.getQueryString('respInfo'));
$(document).ready(function () {
    if(payOrderId != null && payOrderId != ''){
        if(payOrderInfo != null){
            pollingPayResult();
        } else{
            payOrderInfo={
                orderId: orderId,
                detailName:detailName,
                totalFee:totalFee
            }
            sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
            pollingPayResult();
        }
    } else{
        if(payOrderInfo == null){
            payOrderInfo = {};
        }
        payOrderInfo.detailName = respInfo.detailName;
        payOrderInfo.totalFee = respInfo.totalFee;
        payOrderInfo.redirectUrl = respInfo.redirectUrl;
        payOrderInfo.orderId = respInfo.orderId;
        sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));

        pay();
    }
    $("#orderId").html(payOrderInfo.orderId);
    $("#goodsName").html(payOrderInfo.detailName);
    //支付时前台传分，后台返回也是分
    $("#totalFee").html(payOrderInfo.totalFee/100);
});

//支付
function pay(){
    var rspCode = respInfo.rspCode;
    if(rspCode != "0000"){
        util.dialog.alert(respInfo.rspName);
        return;
    }

    //返回成功，跳转支付
    var channel = respInfo.channel;
    if(channel == "23"){
        //支付宝H5支付
        //由于后台对整个json编码，表单中的空格会变成+，所以此处需要将+替换回空格
        var form = $(respInfo.body.replace( /\+/g , ' ' )).appendTo('html');
    }else if(channel == "14"){
        //微信公众号支付
        if (typeof WeixinJSBridge == "undefined"){
            if( document.addEventListener ){
                document.addEventListener('WeixinJSBridgeReady', onBridgeReady, false);
            }else if (document.attachEvent){
                document.attachEvent('WeixinJSBridgeReady', onBridgeReady);
                document.attachEvent('onWeixinJSBridgeReady', onBridgeReady);
            }
        }else{
            onBridgeReady();
        }
    } else {
        util.dialog.alert("暂不支持该支付方式(js)");
        return;
    }
}

//拉起微信支付框
function onBridgeReady(){
    WeixinJSBridge.invoke(
        'getBrandWCPayRequest', {
            "appId": respInfo.appId,  //公众号名称，由商户传入
            "timeStamp": respInfo.timeStamp, //时间戳，自1970年以来的秒数
            "nonceStr" : respInfo.nonceStr, //随机串
            "package" : respInfo.package_,
            "signType" : respInfo.signType, //微信签名方式：
            "paySign" : respInfo.paySign //微信签名
        },
        function(res){
            // 使用以上方式判断前端返回,微信团队郑重提示：res.err_msg将在用户支付成功后返回    ok，但并不保证它绝对可靠。
            if(res.err_msg == "get_brand_wcpay_request:ok") {
                payOrderId = respInfo.payOrderId;
                pollingPayResult();
            }else if(res.err_msg == "get_brand_wcpay_request:cancel"){
                util.dialog.alert('您没有确认支付，请重新扫码支付！');
            }else{
                util.dialog.alert(res.err_desc+'，请重新扫码支付！');
            }
        }
    );
};

var pollingPayResult = function() {
    timersearch = setInterval(function() {
        payWaiting(payOrderId);
    }, 1000);
};

var timersearch = null;
var payTimeout = 10;
var payWaiting = function(payOrderId) {
    if (payTimeout-- >=0) {
        util.loading.show("正在查询支付结果...");
        if (payTimeout === 1) {
            qrySourcePayResult(payOrderId);
        } else {
            qryPayResult(payOrderId);
        }
    } else {
        clearInterval(timersearch);
        util.loading.hide();
        util.dialog.alert('支付已超时，请重新支付');
    }
};

var qryPayResult = function(payOrderId) {
    var data = {};
    data.loadingHide = false;
    data.params = {
        payOrderId: payOrderId
    };
    data.params.service = '/pay/pollingPayState';
    data.successF = function(returnData) {
        if (returnData.payStatus === 'SUCCESS') {
            clearInterval(timersearch);
            util.loading.hide();
            location.replace('payResult.html?payStatus=' + returnData.payStatus + '&orderId='+ orderId);
        }
    };
    data.failF = function(returnData) {

    };
    util.ajax(data);
};

var qrySourcePayResult = function(payOrderId) {
    var data = {};
    data.loadingHide = false;
    data.params = {
        payOrderId: payOrderId
    };
    data.params.service = '/pay/orderQuery';
    data.successF = function(returnData) {
        if (returnData.payStatus == 'SUCCESS') {
            clearInterval(timersearch);
            util.loading.hide();
            location.replace('payResult.html?payStatus=' + returnData.payStatus + '&orderId='+ orderId);
        }
    };
    util.ajax(data);
};



