/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.ability.PayProBillResultDataQryAbilityService;
import com.tydic.payment.pay.ability.bo.PayProBillResultDataQryAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProBillResultDataQryAbilityRspBo;
import com.tydic.payment.pay.common.base.bo.PayProPageRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.PBillResultMapper;
import com.tydic.payment.pay.dao.po.PBillResultPo;
import com.tydic.payment.pay.dao.po.QryBillResultPo;
import com.tydic.payment.pay.icbc.util.StringUtils;
import com.tydic.payment.pay.util.PayProRspPageUtil;
import com.tydic.payment.pay.util.PayProRspUtil;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_TEST/2.0.0/com.tydic.payment.pay.ability.PayProBillResultDataQryAbilityService"})
public class PayProBillResultDataQryAbilityServiceImpl
implements PayProBillResultDataQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PayProBillResultDataQryAbilityServiceImpl.class);
    private static final String BILL_TYPE_DATE = "1";
    private static final String BILL_DATE_FORMAT = "yyyyMMdd";
    private static final String BILL_MONTH_FORMAT = "yyyyMM";
    @Autowired
    private PBillResultMapper pBillResultMapper;

    @PostMapping(value={"queryData"})
    public PayProPageRspBo<PayProBillResultDataQryAbilityRspBo> queryData(@RequestBody PayProBillResultDataQryAbilityReqBo reqBo) {
        List<PBillResultPo> resultPos;
        PayProPageRspBo rspBo = PayProRspUtil.generateSucRspBo(PayProPageRspBo.class);
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((String)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)validateStr);
            rspBo.setRespCode("214033");
            rspBo.setRespDesc(validateStr);
            return rspBo;
        }
        QryBillResultPo qryPo = new QryBillResultPo();
        qryPo.setStartDate(reqBo.getStartDate());
        qryPo.setEndDate(reqBo.getEndDate());
        Page page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        if (BILL_TYPE_DATE.equals(reqBo.getBillType())) {
            resultPos = this.pBillResultMapper.queryResult(qryPo, (Page<PBillResultPo>)page);
        } else {
            DateTime startDate = DateTime.parse((String)reqBo.getStartDate().toString(), (DateTimeFormatter)DateTimeFormat.forPattern((String)BILL_DATE_FORMAT));
            DateTime endDate = DateTime.parse((String)reqBo.getEndDate().toString(), (DateTimeFormatter)DateTimeFormat.forPattern((String)BILL_DATE_FORMAT));
            qryPo.setStartDate(Long.valueOf(startDate.toString(BILL_MONTH_FORMAT)));
            qryPo.setEndDate(Long.valueOf(endDate.toString(BILL_MONTH_FORMAT)));
            resultPos = this.pBillResultMapper.queryMonthResult(qryPo, (Page<PBillResultPo>)page);
        }
        PayProRspPageUtil.fillPageArg(rspBo, page);
        List rows = rspBo.getData().getRows();
        for (PBillResultPo tmp : resultPos) {
            PayProBillResultDataQryAbilityRspBo rt = new PayProBillResultDataQryAbilityRspBo();
            BeanUtils.copyProperties((Object)tmp, (Object)rt);
            if (tmp.getPayCenterPayCount().equals(tmp.getPaymentInsPayCount())) {
                rt.setCountBillResult("\u4e00\u81f4");
            }
            if (tmp.getPayCenterPayFee().equals(tmp.getPaymentInsPayFee())) {
                rt.setFeeBillResult("\u4e00\u81f4");
            }
            if (BILL_TYPE_DATE.equals(reqBo.getBillType())) {
                rt.setBillDate(PayProBillResultDataQryAbilityServiceImpl.convertBillDate(tmp.getBillDate()));
            } else {
                rt.setBillDate(this.convertBillMonth(tmp.getBillMonth()));
            }
            rt.setPayCenterPayFee(MoneyUtils.fenToYuan((Long)tmp.getPayCenterPayFee()));
            rt.setPaymentInsPayFee(MoneyUtils.fenToYuan((Long)tmp.getPaymentInsPayFee()));
            rows.add(rt);
        }
        return rspBo;
    }

    private String validateArgs(PayProBillResultDataQryAbilityReqBo reqBo) {
        String result = ArgValidator.validateArg((Object)reqBo);
        if (!StringUtils.isEmpty((String)result)) {
            return result;
        }
        try {
            DateTime.parse((String)reqBo.getStartDate().toString(), (DateTimeFormatter)DateTimeFormat.forPattern((String)BILL_DATE_FORMAT));
            DateTime.parse((String)reqBo.getEndDate().toString(), (DateTimeFormatter)DateTimeFormat.forPattern((String)BILL_DATE_FORMAT));
        }
        catch (Exception e) {
            return "\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u65e5\u671f\u683c\u5f0f\uff0c\u5982\uff1a20200908";
        }
        return null;
    }

    private String convertBillMonth(Long billMonth) {
        String billMonthStr = billMonth.toString();
        return billMonthStr.substring(0, 4) + "-" + billMonthStr.substring(4, 6);
    }

    public static String convertBillDate(Long billDate) {
        String tmp = billDate.toString();
        return tmp.substring(0, 4) + "-" + tmp.substring(4, 6) + "-" + tmp.substring(6, 8);
    }
}

