/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.ability.PayProOrderAbilityService;
import com.tydic.payment.pay.ability.PayProOrderEncryptAbilityService;
import com.tydic.payment.pay.ability.bo.PayProOrderAbilityServiceReqBo;
import com.tydic.payment.pay.ability.bo.PayProOrderAbilityServiceRspBo;
import com.tydic.payment.pay.ability.bo.PayProOrderEncryptAbilityServiceReqBo;
import com.tydic.payment.pay.ability.bo.PayProOrderEncryptAbilityServiceRspBo;
import com.tydic.payment.pay.busi.DataEncryptionService;
import com.tydic.payment.pay.busi.DataValidationService;
import com.tydic.payment.pay.busi.PayProQueryInfoBusiSystemByConditionService;
import com.tydic.payment.pay.busi.bo.DataEncryptionReqBo;
import com.tydic.payment.pay.busi.bo.DataEncryptionRspBo;
import com.tydic.payment.pay.busi.bo.DataValidationReqBO;
import com.tydic.payment.pay.busi.bo.DataValidationRspBO;
import com.tydic.payment.pay.busi.bo.PayProQueryInfoBusiSystemByConditionBusiInfoRspBo;
import com.tydic.payment.pay.common.util.MapUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_TEST/2.0.0/com.tydic.payment.pay.ability.PayProOrderEncryptAbilityService"})
public class PayProOrderEncryptAbilityServiceImpl
implements PayProOrderEncryptAbilityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PayProOrderEncryptAbilityServiceImpl.class);
    private static final String SERVICE_NAME = "\u4ea7\u54c1\u52a0\u5bc6\u4e0b\u5355\u652f\u4ed8ability\u670d\u52a1";
    @Autowired
    private PayProOrderAbilityService payProOrderAbilityService;
    @Autowired
    private PayProQueryInfoBusiSystemByConditionService queryInfoBusiSystemByConditionService;
    @Autowired
    private DataValidationService dataValidationService;
    @Autowired
    private DataEncryptionService dataEncryptionService;

    @PostMapping(value={"dealOrder"})
    public PayProOrderEncryptAbilityServiceRspBo dealOrder(@RequestBody PayProOrderEncryptAbilityServiceReqBo reqBo) {
        PayProOrderAbilityServiceReqBo orderReqBo;
        DataValidationRspBO dataValidationRspBO;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("\u4ea7\u54c1\u52a0\u5bc6\u4e0b\u5355\u652f\u4ed8ability\u670d\u52a1-> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        }
        PayProOrderEncryptAbilityServiceRspBo retBo = new PayProOrderEncryptAbilityServiceRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("214018");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String busiCode = reqBo.getBusiCode();
        PayProQueryInfoBusiSystemByConditionBusiInfoRspBo busiCodeRspBo = this.queryInfoBusiSystemByConditionService.queryBusiSysByBusiCode(busiCode);
        if (!"0000".equals(busiCodeRspBo.getRespCode())) {
            retBo.setRespCode("214018");
            retBo.setRespDesc("\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u5931\u8d25:" + busiCodeRspBo.getRespDesc());
            return retBo;
        }
        if (!"1".equals(busiCodeRspBo.getState())) {
            retBo.setRespCode("214018");
            retBo.setRespDesc("\u8be5\u4e1a\u52a1\u7cfb\u7edf(" + busiCode + ")\u5df2\u5931\u6548");
            return retBo;
        }
        Long busiId = busiCodeRspBo.getBusiId();
        DataValidationReqBO dataValidationReqBO = new DataValidationReqBO();
        dataValidationReqBO.setBusiId(busiCodeRspBo.getBusiId() + "");
        dataValidationReqBO.setContent(reqBo.getContent());
        try {
            dataValidationRspBO = this.dataValidationService.validation(dataValidationReqBO);
        }
        catch (Exception e) {
            LOGGER.error("\u4ea7\u54c1\u52a0\u5bc6\u4e0b\u5355\u652f\u4ed8ability\u670d\u52a1 -> \u89e3\u5bc6\u5f02\u5e38\uff1a" + e);
            retBo.setRespCode("214018");
            retBo.setRespDesc("\u89e3\u5bc6\u5f02\u5e38\uff1a" + e.getMessage());
            return retBo;
        }
        if (!"0000".equals(dataValidationRspBO.getRspCode())) {
            LOGGER.error("\u4ea7\u54c1\u52a0\u5bc6\u4e0b\u5355\u652f\u4ed8ability\u670d\u52a1 -> \u89e3\u5bc6\u5931\u8d25:" + JSON.toJSONString((Object)dataValidationRspBO));
            retBo.setRespCode("214018");
            retBo.setRespDesc(dataValidationRspBO.getRspName());
            return retBo;
        }
        if (!dataValidationRspBO.isSign()) {
            retBo.setRespCode("214018");
            retBo.setRespDesc("\u9a8c\u8bc1\u7b7e\u540d\u4e0d\u901a\u8fc7");
            return retBo;
        }
        try {
            orderReqBo = (PayProOrderAbilityServiceReqBo)MapUtils.mapToObject((Map)dataValidationRspBO.getContentMap(), PayProOrderAbilityServiceReqBo.class);
        }
        catch (Exception e) {
            retBo.setRespCode("214018");
            retBo.setRespDesc("\u4ea7\u54c1\u52a0\u5bc6\u4e0b\u5355\u652f\u4ed8ability\u670d\u52a1 -> \u89e3\u5bc6\u540e\u8f6c\u6362\u5bf9\u8c61\u5f02\u5e38\uff1a" + e);
            return retBo;
        }
        PayProOrderAbilityServiceRspBo orderRspBo = this.payProOrderAbilityService.dealOrder(orderReqBo);
        if (!"0000".equals(orderRspBo.getRespCode())) {
            retBo.setRespCode("214018");
            retBo.setRespDesc("\u8c03\u7528\u4e0d\u52a0\u5bc6\u670d\u52a1\u5931\u8d25\uff1a" + orderRspBo.getRespDesc());
            return retBo;
        }
        DataEncryptionReqBo dataReqBo = new DataEncryptionReqBo();
        JSONObject content = JSONObject.parseObject((String)JSONObject.toJSONString((Object)orderRspBo));
        content.remove((Object)"respCode");
        content.remove((Object)"respDesc");
        dataReqBo.setBusiId(busiId + "");
        dataReqBo.setContent(content.toString());
        DataEncryptionRspBo dataEncryptionRspBo = this.dataEncryptionService.dataEncryption(dataReqBo);
        if (!"0000".equals(dataEncryptionRspBo.getRspCode())) {
            retBo.setRespCode("214018");
            retBo.setRespDesc("\u4ea7\u54c1\u52a0\u5bc6\u4e0b\u5355\u652f\u4ed8ability\u670d\u52a1 -> RSA\u52a0\u5bc6\u5f02\u5e38\uff1a" + dataEncryptionRspBo.getRspName());
            return retBo;
        }
        retBo.setBusiCode(reqBo.getBusiCode());
        retBo.setContent(dataEncryptionRspBo.getEncrypData());
        retBo.setRespDesc(orderRspBo.getRespDesc());
        retBo.setRespCode("0000");
        return retBo;
    }

    private String validateArg(PayProOrderEncryptAbilityServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiCode())) {
            return "busiCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getContent())) {
            return "content\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

