/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.busi.CashPayBusiService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.CashPayBusiReqBo;
import com.tydic.payment.pay.busi.bo.CashPayBusiRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="cashPayBusiService")
public class CashPayBusiServiceImpl
implements CashPayBusiService {
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;

    public CashPayBusiRspBo dealCashPay(CashPayBusiReqBo req) throws Exception {
        CashPayBusiRspBo rsp = new CashPayBusiRspBo();
        try {
            this.checkInputParas(req);
            PorderPo orderInfo = this.payOrderAtomService.queryPorderInfo(Long.valueOf(req.getOrderId()));
            if (orderInfo == null) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5fae\u4fe1\u6761\u7801\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u6839\u636e\u8ba2\u5355id\u3010ORDER_ID=" + req.getOrderId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f\uff01");
            }
            PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
            orderPayTransAtomReq.setOrderId(orderInfo.getOrderId());
            orderPayTransAtomReq.setBusiId(orderInfo.getBusiId());
            orderPayTransAtomReq.setMerchantId(Long.parseLong(req.getMerchantId()));
            orderPayTransAtomReq.setPayMethod(Long.parseLong("30"));
            orderPayTransAtomReq.setOrderStatus("A10");
            orderPayTransAtomReq.setTradeTime(new SimpleDateFormat("yyyyMMddHHmmss").format(this.queryDBDateBusiService.getDBDate()));
            orderPayTransAtomReq.setPayFee(MoneyUtils.fenToHaoToLong((BigDecimal)req.getTotalFee()));
            String payOrderId = this.porderPayTransAtomService.createOrderPayTrans(orderPayTransAtomReq);
            orderInfo.setOrderStatus("A10");
            orderInfo.setRealFee(orderPayTransAtomReq.getPayFee());
            orderInfo.setTradeTime(orderPayTransAtomReq.getTradeTime());
            orderInfo.setPayNotifyCode("0");
            orderInfo.setPayNotifyTime(this.queryDBDateBusiService.getDBDate());
            orderInfo.setRealFee(orderPayTransAtomReq.getPayFee());
            this.payOrderAtomService.update(orderInfo);
            rsp.setRspCode("0000");
            rsp.setRspName("\u6210\u529f");
            rsp.setPayStatus("SUCCESS");
            rsp.setPayOrderId(payOrderId);
        }
        catch (Exception e) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u73b0\u91d1\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a" + e);
            rsp.setPayStatus("FAIL");
        }
        return rsp;
    }

    private void checkInputParas(CashPayBusiReqBo req) {
        if (StringUtils.isEmpty((Object)req.getOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u73b0\u91d1\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getMerchantId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u73b0\u91d1\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u8ba2\u5355\u7f16\u53f7\u3010merchantId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getTotalFee())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u73b0\u91d1\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u652f\u4ed8\u91d1\u989d\u3010totalFee\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

