/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.ability.bo.PayProMerchantPayInsDataBo;
import com.tydic.payment.pay.ability.bo.PayProPayInsParaDataBo;
import com.tydic.payment.pay.busi.PayProBillCheckConfigBusiService;
import com.tydic.payment.pay.busi.bo.PayProBillCheckConfigBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProBillCheckConfigBusiRspBo;
import com.tydic.payment.pay.constant.PayConfigConstants;
import com.tydic.payment.pay.dao.BillCheckConfigMapper;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.dao.PayParaRuleMapper;
import com.tydic.payment.pay.dao.po.BillCheckConfigPO;
import com.tydic.payment.pay.dao.po.PayParaRulePo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.icbc.util.StringUtils;
import com.tydic.payment.pay.util.PayProRspUtil;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="payProBillCheckConfigBusiService")
public class PayProBillCheckConfigBusiServiceImpl
implements PayProBillCheckConfigBusiService {
    private static final Logger log = LoggerFactory.getLogger(PayProBillCheckConfigBusiServiceImpl.class);
    @Value(value="${supported.bill.payment.ins:1,2,18,,19,16}")
    private String supportedPayment;
    @Autowired
    private BillCheckConfigMapper billCheckConfigMapper;
    @Autowired
    private PayParaRuleMapper payParaRuleMapper;
    @Autowired
    private PayMethodMapper payMethodMapper;
    private Set<String> supportedPaymentSet = new HashSet<String>(16);

    @PostConstruct
    private void init() {
        if (!StringUtils.isEmpty((String)this.supportedPayment)) {
            Collections.addAll(this.supportedPaymentSet, this.supportedPayment.split(","));
        }
    }

    public PayProBillCheckConfigBusiRspBo addBillConfig(PayProBillCheckConfigBusiReqBo reqBo) {
        PayProBillCheckConfigBusiRspBo retBo = PayProRspUtil.generateRspBo("8888", "\u5931\u8d25", PayProBillCheckConfigBusiRspBo.class);
        this.validateArgs(reqBo);
        PayProMerchantPayInsDataBo paymentIns = reqBo.getPaymentIns();
        List payParaList = paymentIns.getPayParaList();
        if (!this.supportedPaymentSet.contains(paymentIns.getPaymentInsId().toString())) {
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u6210\u529f");
            return retBo;
        }
        PayParaRulePo queryRulePo = new PayParaRulePo();
        queryRulePo.setPaymentInsMerchanted(PayConfigConstants.PAY_RULE_IS_PAYMENT_INS_MERCHANT);
        queryRulePo.setPaymentInsId(paymentIns.getPaymentInsId());
        List<PayParaRulePo> rulePos = this.payParaRuleMapper.queryPayParaRuleByCondition(queryRulePo);
        if (CollectionUtils.isEmpty(rulePos)) {
            log.error("\u672a\u83b7\u53d6\u5230\u652f\u4ed8\u673a\u6784\u7684\u4e3b\u5546\u6237\u53c2\u6570\u89c4\u5219");
            retBo.setRespDesc("\u672a\u83b7\u53d6\u5230\u652f\u4ed8\u673a\u6784\u7684\u4e3b\u5546\u6237\u53c2\u6570\u89c4\u5219");
            return retBo;
        }
        PayParaRulePo rulePo = rulePos.get(0);
        String paymentInsMerchantCode = rulePo.getParameterCode();
        String paymentMchId = null;
        for (PayProPayInsParaDataBo paraData : payParaList) {
            if (!paymentInsMerchantCode.equals(paraData.getParameterCode())) continue;
            paymentMchId = paraData.getParameterValue();
        }
        if (StringUtils.isEmpty(paymentMchId)) {
            log.error("\u4ece\u5165\u53c2\u4e2d\u672a\u83b7\u53d6\u5230\u652f\u4ed8\u673a\u6784\u7684\u5546\u6237\u53f7");
            retBo.setRespDesc("\u4ece\u5165\u53c2\u4e2d\u672a\u83b7\u53d6\u5230\u652f\u4ed8\u673a\u6784\u7684\u5546\u6237\u53f7");
            return retBo;
        }
        Date nowTime = this.payMethodMapper.getDBDate().getDate();
        BillCheckConfigPO billConfigPo = new BillCheckConfigPO();
        billConfigPo.setPaymentInsId(paymentIns.getPaymentInsId());
        billConfigPo.setPayCenterMerchant(Long.valueOf(reqBo.getMerchantId()));
        billConfigPo.setPaymentMchId(paymentMchId);
        billConfigPo.setLastResult("1");
        billConfigPo.setNextDate(Long.valueOf(new DateTime((Object)nowTime).toString("yyyyMMdd")));
        billConfigPo.setEffFlag("1");
        billConfigPo.setLastResultCode("0000");
        billConfigPo.setLastResultDesc("\u6210\u529f");
        int result = this.billCheckConfigMapper.insert(billConfigPo);
        if (result < 1) {
            throw new BusinessException("218024", "\u5199\u5165\u5bf9\u8d26\u914d\u7f6e\u8868\u5931\u8d25\uff1a\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    public PayProBillCheckConfigBusiRspBo updateBillConfig(PayProBillCheckConfigBusiReqBo reqBo) {
        PayProBillCheckConfigBusiRspBo retBo = new PayProBillCheckConfigBusiRspBo();
        PayProMerchantPayInsDataBo paymentIns = reqBo.getPaymentIns();
        if (!this.supportedPaymentSet.contains(paymentIns.getPaymentInsId().toString())) {
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u6210\u529f");
            return retBo;
        }
        this.deleteBillConfig(reqBo);
        retBo = this.addBillConfig(reqBo);
        return retBo;
    }

    public PayProBillCheckConfigBusiRspBo deleteBillConfig(PayProBillCheckConfigBusiReqBo reqBo) {
        PayProBillCheckConfigBusiRspBo retBo = PayProRspUtil.generateSucRspBo(PayProBillCheckConfigBusiRspBo.class);
        this.validateArgs(reqBo);
        PayProMerchantPayInsDataBo paymentIns = reqBo.getPaymentIns();
        if (!this.supportedPaymentSet.contains(paymentIns.getPaymentInsId().toString())) {
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u6210\u529f");
            return retBo;
        }
        BillCheckConfigPO billConfigPo = new BillCheckConfigPO();
        billConfigPo.setPayCenterMerchant(Long.valueOf(reqBo.getMerchantId()));
        billConfigPo.setPaymentInsId(paymentIns.getPaymentInsId());
        this.billCheckConfigMapper.deleteByCondition(billConfigPo);
        if (log.isDebugEnabled()) {
            log.debug("\u5bf9\u8d26\u914d\u7f6e\u5220\u9664\uff1a\u5546\u6237\uff1a[{}]\uff0c\u652f\u4ed8\u673a\u6784\uff1a[{}]", (Object)reqBo.getMerchantId(), (Object)paymentIns.getPaymentInsId());
        }
        return retBo;
    }

    private void validateArgs(PayProBillCheckConfigBusiReqBo reqBo) {
        if (null == reqBo) {
            throw new BusinessException("218024", "\u5bf9\u8d26\u914d\u7f6e\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBo.getMerchantId())) {
            throw new BusinessException("218024", "\u5546\u6237ID[merchantId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getPaymentIns()) {
            throw new BusinessException("218024", "\u652f\u4ed8\u673a\u6784\u4fe1\u606f[paymentIns]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

