/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.busi.QueryPCodeInfoService;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoReqBO;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoRspBO;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.MerchantInfoPageReqPO;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.web.bo.MerchantInfoBoStr;
import com.tydic.payment.pay.web.bo.req.QueryMerchantApproveWebReqBo;
import com.tydic.payment.pay.web.service.QueryMerchantApproveWebService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_TEST/2.0.0/com.tydic.payment.pay.web.service.QueryMerchantApproveWebService"})
public class QueryMerchantApproveWebServiceImpl
implements QueryMerchantApproveWebService {
    private static final Logger log = LoggerFactory.getLogger(QueryMerchantApproveWebServiceImpl.class);
    private static String SERVICE_NAME = "\u67e5\u8be2\u5546\u6237\u5ba1\u6279\u72b6\u6001Web\u670d\u52a1";
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private QueryPCodeInfoService queryPCodeInfoService;

    @PostMapping(value={"queryInfoMerchantApprove"})
    public RspPage<MerchantInfoBoStr> queryInfoMerchantApprove(@RequestBody QueryMerchantApproveWebReqBo reqBo) {
        log.info(SERVICE_NAME + " -> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        RspPage rspBo = new RspPage();
        ArrayList<MerchantInfoBoStr> rspList = new ArrayList<MerchantInfoBoStr>();
        rspBo.setRows(rspList);
        if (reqBo == null) {
            reqBo = new QueryMerchantApproveWebReqBo();
        }
        MerchantInfoPageReqPO qryMerPagePo = new MerchantInfoPageReqPO();
        this.beforeCopy(reqBo, qryMerPagePo);
        if (qryMerPagePo.getPageNo() < 0) {
            qryMerPagePo.setPageNo(1);
        }
        if (qryMerPagePo.getPageSize() < 1) {
            qryMerPagePo.setPageSize(10);
        }
        Page page = null;
        if (reqBo.getPageNo() > 1) {
            page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (page.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (page.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        List<MerChantInfoPo> qryMerL = this.merchantInfoAtomService.queryMerchantInfoByFlagSetWithPage((Page<MerchantInfoPageReqPO>)page, qryMerPagePo, reqBo.getFlagSet());
        if (qryMerL == null || qryMerL.size() < 1) {
            log.info(SERVICE_NAME + "\u67e5\u8be2\u6210\u529f\uff0c\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e");
            rspBo.setPageNo(1);
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            return rspBo;
        }
        this.afterCopy(qryMerL, rspList);
        rspBo.setRows(rspList);
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        return rspBo;
    }

    private boolean afterCopy(List<MerChantInfoPo> qryMerL, List<MerchantInfoBoStr> rspList) {
        boolean translateFlag = true;
        for (MerChantInfoPo temp : qryMerL) {
            MerchantInfoBoStr tempBo = new MerchantInfoBoStr();
            BeanUtils.copyProperties((Object)temp, (Object)tempBo);
            tempBo.setMerchantId(temp.getMerchantId() == null ? "" : temp.getMerchantId().toString());
            tempBo.setCreateTime(temp.getCreateTime() == null ? "" : new DateTime((Object)temp.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
            tempBo.setUpdateTime(temp.getUpdateTime() == null ? "" : new DateTime((Object)temp.getUpdateTime()).toString("yyyy-MM-dd HH:mm:ss"));
            tempBo.setMainMerchantId(temp.getMainMerchantId() == null ? "" : temp.getMainMerchantId().toString());
            tempBo.setMerchantType(temp.getMerchantType() == null ? "" : temp.getMerchantType().toString());
            tempBo.setApproveTime(temp.getApproveTime() == null ? "" : new DateTime((Object)temp.getApproveTime()).toString("yyyy-MM-dd HH:mm:ss"));
            try {
                if (temp.getMainMerchantId() != null) {
                    MerChantInfoPo qryResultPo = this.merchantInfoAtomService.queryMerchantInfoById(temp.getMainMerchantId());
                    if (qryResultPo == null) {
                        tempBo.setMainMerchantName("-\u4e3b\u5546\u6237\u4e0d\u5b58\u5728-");
                    } else {
                        tempBo.setMainMerchantName(StringUtils.isEmpty((Object)qryResultPo.getMerchantName()) ? "" : qryResultPo.getMerchantName());
                    }
                } else {
                    tempBo.setMainMerchantName("");
                }
                if (temp.getMerchantType() != null) {
                    QueryPCodeInfoReqBO queryPCodeInfoReqMT = new QueryPCodeInfoReqBO();
                    queryPCodeInfoReqMT.setTypeCode("MERCHANT_TYPE");
                    queryPCodeInfoReqMT.setCodeValue(String.valueOf(temp.getMerchantType()));
                    QueryPCodeInfoRspBO queryPCodeInfoRspMT = this.queryPCodeInfoService.queryPCodeInfo(queryPCodeInfoReqMT);
                    tempBo.setMerchantTypeName(queryPCodeInfoRspMT.getCodeInfo() == null ? "" : queryPCodeInfoRspMT.getCodeInfo());
                } else {
                    tempBo.setMerchantTypeName("");
                }
                if (!StringUtils.isEmpty((Object)temp.getFlag())) {
                    QueryPCodeInfoReqBO queryPCodeInfoReqFlag = new QueryPCodeInfoReqBO();
                    queryPCodeInfoReqFlag.setTypeCode("MERCHANT_FLAG");
                    queryPCodeInfoReqFlag.setCodeValue(temp.getFlag());
                    QueryPCodeInfoRspBO queryPCodeInfoRspFlag = this.queryPCodeInfoService.queryPCodeInfo(queryPCodeInfoReqFlag);
                    tempBo.setFlagName(queryPCodeInfoRspFlag.getCodeInfo() == null ? "" : queryPCodeInfoRspFlag.getCodeInfo());
                } else {
                    tempBo.setFlagName("");
                }
            }
            catch (Exception e) {
                translateFlag = false;
                log.info("\u6570\u636e\u7ffb\u8bd1\u9519\u8bef");
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6570\u636e\u5b57\u5178\u7ffb\u8bd1\u9519\u8bef");
            }
            rspList.add(tempBo);
        }
        return translateFlag;
    }

    private void beforeCopy(QueryMerchantApproveWebReqBo reqBo, MerchantInfoPageReqPO qryMerPagePo) {
        BeanUtils.copyProperties((Object)reqBo, (Object)((Object)qryMerPagePo));
        try {
            if (reqBo.getFlagSet().isEmpty()) {
                HashSet<String> flagSet = new HashSet<String>();
                flagSet.add("1");
                flagSet.add("3");
                reqBo.setFlagSet(flagSet);
            }
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u6237\u5ba1\u6279\u5217\u8868\u67e5\u8be2\u670d\u52a1\u5165\u53c2\u5b57\u6bb5\u975e\u6cd5");
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateTimeStart())) {
            qryMerPagePo.setCreateTimeStart(new DateTime((Object)reqBo.getCreateTimeStart()).withMillisOfDay(0).toString());
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateTimeEnd())) {
            qryMerPagePo.setCreateTimeEnd(new DateTime((Object)reqBo.getCreateTimeEnd()).plusDays(1).withMillisOfDay(0).toString());
        }
        if (!StringUtils.isEmpty((Object)reqBo.getUpdateTimeStart())) {
            qryMerPagePo.setUpdateTimeStart(new DateTime((Object)reqBo.getUpdateTimeStart()).withMillisOfDay(0).toString());
        }
        if (!StringUtils.isEmpty((Object)reqBo.getUpdateTimeEnd())) {
            qryMerPagePo.setUpdateTimeEnd(new DateTime((Object)reqBo.getUpdateTimeEnd()).plusDays(1).withMillisOfDay(0).toString());
        }
        if (!StringUtils.isEmpty((Object)reqBo.getApproveTimeStart())) {
            qryMerPagePo.setApproveTimeStart(new DateTime((Object)reqBo.getApproveTimeStart()).withMillisOfDay(0).toString());
        }
        if (!StringUtils.isEmpty((Object)reqBo.getApproveTimeEnd())) {
            qryMerPagePo.setApproveTimeEnd(new DateTime((Object)reqBo.getApproveTimeEnd()).plusDays(1).withMillisOfDay(0).toString());
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            qryMerPagePo.setMerchantId(Long.valueOf(reqBo.getMerchantId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMainMerchantId())) {
            qryMerPagePo.setMainMerchantId(Long.valueOf(reqBo.getMainMerchantId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMerchantType())) {
            qryMerPagePo.setMerchantType(Integer.valueOf(reqBo.getMerchantType()));
        }
    }
}

