/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.busi.PayProQueryOrderTransPageBusiService;
import com.tydic.payment.pay.busi.bo.PayProQueryOrderTransBusiDataBo;
import com.tydic.payment.pay.busi.bo.PayProQueryOrderTransPageBusiReqBo;
import com.tydic.payment.pay.common.base.bo.PayFrontBaseRspBo;
import com.tydic.payment.pay.common.base.bo.PayFrontPageRspBo;
import com.tydic.payment.pay.dao.MerChantInfoMapper;
import com.tydic.payment.pay.dao.PorderTransforTransMapper;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.PorderTransforTransPo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PayProQueryOrderTransPageBusiServiceImpl
implements PayProQueryOrderTransPageBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PorderTransforTransMapper porderTransforTransMapper;
    @Autowired
    private MerChantInfoMapper merChantInfoMapper;

    public PayFrontBaseRspBo<PayFrontPageRspBo<PayProQueryOrderTransBusiDataBo>> queryTrans(PayProQueryOrderTransPageBusiReqBo reqBo) {
        this.LOGGER.info("\u8f6c\u8d26\u8bb0\u5f55\u67e5\u8be2\u670d\u52a1\uff1a" + reqBo);
        PayFrontBaseRspBo retBo = new PayFrontBaseRspBo();
        PayFrontPageRspBo data = new PayFrontPageRspBo();
        ArrayList<PayProQueryOrderTransBusiDataBo> transList = new ArrayList<PayProQueryOrderTransBusiDataBo>();
        data.setRows(transList);
        Page transPage = new Page();
        if (reqBo.getPageNo() > 1) {
            transPage = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        } else {
            transPage = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)transPage);
            if (transPage.getPageNo() < 1) {
                transPage.setPageNo(1);
            }
            if (transPage.getPageSize() < 1) {
                transPage.setPageSize(10);
            }
        }
        PorderTransforTransPo qryReqPo = new PorderTransforTransPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryReqPo);
        List<PorderTransforTransPo> poList = this.porderTransforTransMapper.selectByConditionWithPage(qryReqPo, (Page<PorderTransforTransPo>)transPage);
        if (CollectionUtils.isEmpty(poList)) {
            this.LOGGER.error("\u67e5\u8be2\u8f6c\u8d26\u8bb0\u5f55\u8868\u8fd4\u56de\u4e3a\u7a7a");
            retBo.setRespCode("212036");
            retBo.setRespDesc("\u67e5\u8be2\u8f6c\u8d26\u8bb0\u5f55\u8868\u8fd4\u56de\u4e3a\u7a7a");
            return retBo;
        }
        Map<Long, String> merchantMap = this.queryMerchant();
        for (PorderTransforTransPo transPo : poList) {
            PayProQueryOrderTransBusiDataBo dataBo = new PayProQueryOrderTransBusiDataBo();
            BeanUtils.copyProperties((Object)transPo, (Object)dataBo);
            dataBo.setMerchantName(merchantMap.get(dataBo.getMerchantId()));
            transList.add(dataBo);
        }
        data.setPageNo(transPage.getPageNo());
        data.setTotal(transPage.getTotalPages());
        data.setRecordsTotal(transPage.getTotalCount());
        retBo.setData((Object)data);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private Map<Long, String> queryMerchant() {
        MerChantInfoPo merchantPo = new MerChantInfoPo();
        List<MerChantInfoPo> merchantList = this.merChantInfoMapper.queryMerChantIdAndNameByCondition(merchantPo);
        HashMap<Long, String> merchantMap = new HashMap<Long, String>(16);
        for (MerChantInfoPo po : merchantList) {
            merchantMap.put(po.getMerchantId(), po.getMerchantName());
        }
        return merchantMap;
    }
}

