/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.thoughtworks.xstream.io.StreamException;
import com.tydic.payment.pay.busi.WXPayApiBusiService;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.wx.req.bo.WXApiCloseOrderReqBO;
import com.tydic.payment.pay.wx.req.bo.WXApiDownloadBillReqBO;
import com.tydic.payment.pay.wx.req.bo.WXApiMicroPayReqBO;
import com.tydic.payment.pay.wx.req.bo.WXApiOrderQueryReqBO;
import com.tydic.payment.pay.wx.req.bo.WXApiRefundReqBO;
import com.tydic.payment.pay.wx.req.bo.WXApiReverseReqBO;
import com.tydic.payment.pay.wx.req.bo.WXApiUnifiedOrderReqBO;
import com.tydic.payment.pay.wx.rsp.bo.WXApiCloseOrderRspBO;
import com.tydic.payment.pay.wx.rsp.bo.WXApiDownloadBillRspBO;
import com.tydic.payment.pay.wx.rsp.bo.WXApiMicroPayRspBO;
import com.tydic.payment.pay.wx.rsp.bo.WXApiOrderQueryRspBO;
import com.tydic.payment.pay.wx.rsp.bo.WXApiRefundRspBO;
import com.tydic.payment.pay.wx.rsp.bo.WXApiReverseRspBO;
import com.tydic.payment.pay.wx.rsp.bo.WXApiUnifiedOrderRspBO;
import com.tydic.payment.pay.wx.util.HttpsRequest;
import com.tydic.payment.pay.wx.util.Signature;
import com.tydic.payment.pay.wx.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wXPayApiBusiService")
public class WXPayApiBusiServiceImpl
implements WXPayApiBusiService {
    private static final Logger log = LoggerFactory.getLogger(WXPayApiBusiServiceImpl.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;

    public WXApiUnifiedOrderRspBO unifiedOrder(WXApiUnifiedOrderReqBO req) throws Exception {
        log.info("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355api" + req);
        HttpsRequest httpsRequest = new HttpsRequest();
        String resultString = httpsRequest.sendPost(this.payPropertiesVo.getWXUnifiedOrderUrl(), (Object)req);
        log.info("---------\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c----------");
        log.info(resultString);
        WXApiUnifiedOrderRspBO rsp = (WXApiUnifiedOrderRspBO)Util.getObjectFromXMLGeneric((String)resultString, WXApiUnifiedOrderRspBO.class);
        if (rsp != null && "SUCCESS".equals(rsp.getReturn_code()) && "SUCCESS".equals(rsp.getResult_code()) && !Signature.checkIsSignValidFromResponseString((String)resultString, (String)req.getKey())) {
            throw new Exception("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        return rsp;
    }

    public WXApiMicroPayRspBO microPay(WXApiMicroPayReqBO req) throws Exception {
        log.info("\u5fae\u4fe1\u5237\u5361\u652f\u4ed8api" + req);
        HttpsRequest httpsRequest = new HttpsRequest();
        String resultString = httpsRequest.sendPost(this.payPropertiesVo.getWXMicoPayUrl(), (Object)req);
        log.info("---------\u5fae\u4fe1\u5237\u5361\u652f\u4ed8\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c----------");
        log.info(resultString);
        WXApiMicroPayRspBO resData = (WXApiMicroPayRspBO)Util.getObjectFromXMLGeneric((String)resultString, WXApiMicroPayRspBO.class);
        if (resData != null && "SUCCESS".equals(resData.getReturn_code()) && "SUCCESS".equals(resData.getResult_code()) && !Signature.checkIsSignValidFromResponseString((String)resultString, (String)req.getKey())) {
            throw new Exception("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        return resData;
    }

    public WXApiOrderQueryRspBO orderQuery(WXApiOrderQueryReqBO req) throws Exception {
        log.info("\u5fae\u4fe1\u67e5\u8be2\u8ba2\u5355api" + req);
        HttpsRequest httpsRequest = new HttpsRequest();
        String resultString = httpsRequest.sendPost(this.payPropertiesVo.getWXOrderQueryUrl(), (Object)req);
        log.info("---------\u5fae\u4fe1\u67e5\u8be2\u8ba2\u5355\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c----------");
        log.info(resultString);
        WXApiOrderQueryRspBO resData = (WXApiOrderQueryRspBO)Util.getObjectFromXMLGeneric((String)resultString, WXApiOrderQueryRspBO.class);
        if (resData != null && "SUCCESS".equals(resData.getReturn_code()) && "SUCCESS".equals(resData.getResult_code()) && !Signature.checkIsSignValidFromResponseString((String)resultString, (String)req.getKey())) {
            throw new Exception("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        return resData;
    }

    public WXApiReverseRspBO reverse(WXApiReverseReqBO req, String certPath, String certPassword) throws Exception {
        log.info("\u5fae\u4fe1\u64a4\u9500\u8ba2\u5355api" + req);
        HttpsRequest httpsRequest = new HttpsRequest(certPath, certPassword);
        String resultString = httpsRequest.sendPost(this.payPropertiesVo.getWXReverse(), (Object)req);
        log.info("---------\u5fae\u4fe1\u64a4\u9500\u8ba2\u5355\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c----------");
        log.info(resultString);
        WXApiReverseRspBO resData = (WXApiReverseRspBO)Util.getObjectFromXMLGeneric((String)resultString, WXApiReverseRspBO.class);
        if (resData != null && "SUCCESS".equals(resData.getReturn_code()) && "SUCCESS".equals(resData.getResult_code()) && !Signature.checkIsSignValidFromResponseString((String)resultString, (String)req.getKey())) {
            throw new Exception("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        return resData;
    }

    public WXApiRefundRspBO refund(WXApiRefundReqBO req, String certPath, String certPassword) throws Exception {
        log.info("\u5fae\u4fe1\u7533\u8bf7\u9000\u6b3eapi" + req);
        HttpsRequest httpsRequest = new HttpsRequest(certPath, certPassword);
        String resultString = httpsRequest.sendPost(this.payPropertiesVo.getWXRefund(), (Object)req);
        log.info("---------\u5fae\u4fe1\u7533\u8bf7\u9000\u6b3eapi\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c----------");
        log.info(resultString);
        WXApiRefundRspBO resData = (WXApiRefundRspBO)Util.getObjectFromXMLGeneric((String)resultString, WXApiRefundRspBO.class);
        if ("SUCCESS".equals(resData.getReturn_code()) && "SUCCESS".equals(resData.getResult_code()) && !Signature.checkIsSignValidFromResponseString((String)resultString, (String)req.getKey())) {
            throw new Exception("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        return resData;
    }

    public WXApiCloseOrderRspBO closeOrder(WXApiCloseOrderReqBO req) throws Exception {
        log.info("\u5fae\u4fe1\u5173\u95ed\u8ba2\u5355api" + req);
        HttpsRequest httpsRequest = new HttpsRequest();
        String resultString = httpsRequest.sendPost(this.payPropertiesVo.getWXCloseOrder(), (Object)req);
        log.info("---------\u5fae\u4fe1\u5173\u95ed\u8ba2\u5355api\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c----------");
        log.info(resultString);
        WXApiCloseOrderRspBO resData = (WXApiCloseOrderRspBO)Util.getObjectFromXMLGeneric((String)resultString, WXApiCloseOrderRspBO.class);
        if ("SUCCESS".equals(resData.getReturn_code()) && "SUCCESS".equals(resData.getResult_code()) && !Signature.checkIsSignValidFromResponseString((String)resultString, (String)req.getKey())) {
            throw new Exception("\u5173\u95ed\u8ba2\u5355\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        return resData;
    }

    public WXApiDownloadBillRspBO downloadBill(WXApiDownloadBillReqBO req) throws Exception {
        log.info("\u5fae\u4fe1\u4e0b\u8f7d\u5bf9\u8d26\u5355api" + req);
        HttpsRequest httpsRequest = new HttpsRequest();
        String resultString = httpsRequest.sendPost(this.payPropertiesVo.getWXDownloadBill(), (Object)req);
        log.info("---------\u5fae\u4fe1\u4e0b\u8f7d\u5bf9\u8d26\u5355api\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c----------");
        log.info(resultString);
        WXApiDownloadBillRspBO resData = new WXApiDownloadBillRspBO();
        try {
            resData = (WXApiDownloadBillRspBO)Util.getObjectFromXMLGeneric((String)resultString, WXApiDownloadBillRspBO.class);
        }
        catch (StreamException e) {
            resData.setBillContent(resultString);
        }
        return resData;
    }
}

