/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.busi.CallBackNoticeService;
import com.tydic.payment.pay.busi.PayInfoContractUpdateService;
import com.tydic.payment.pay.busi.PayProProcessNotifyBusiService;
import com.tydic.payment.pay.busi.bo.CallBackNoticeReqBo;
import com.tydic.payment.pay.busi.bo.CallBackNoticeRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackRspBo;
import com.tydic.payment.pay.busi.bo.PayInfoContractUpdateBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayInfoContractUpdateBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProProcessNotifyBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProProcessNotifyBusiRspBo;
import com.tydic.payment.pay.comb.PayProProcessNoticeCombService;
import com.tydic.payment.pay.comb.bo.PayProProcessNoticeCombReqBo;
import com.tydic.payment.pay.comb.bo.PayProProcessNoticeCombRspBo;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.util.PayAbleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_TEST/2.0.0/com.tydic.payment.pay.comb.PayProProcessNoticeCombService"})
public class PayProProcessNoticeCombServiceImpl
implements PayProProcessNoticeCombService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayAbleManager payAbleManager;
    @Autowired
    private PayProProcessNotifyBusiService payProProcessNotifyBusiService;
    @Autowired
    private CallBackNoticeService callBackNoticeService;
    @Autowired
    private PayInfoContractUpdateService payInfoContractUpdateService;

    @PostMapping(value={"processNotice"})
    public PayProProcessNoticeCombRspBo processNotice(@RequestBody PayProProcessNoticeCombReqBo reqBo) {
        PayProProcessNoticeCombRspBo rspBo = new PayProProcessNoticeCombRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBo.setRespCode("213006");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBo;
        }
        PayAble payAble = this.payAbleManager.getPayAbleByPayMethod(reqBo.getPayMethod());
        PayAbleCallBackReqBo callbackBo = new PayAbleCallBackReqBo();
        callbackBo.setReqData(reqBo.getReqData());
        PayAbleCallBackRspBo payAbleCallBackRspBo = payAble.dealCallBack(callbackBo);
        this.LOGGER.info("\u8c03\u7528able\u5904\u7406\u56de\u8c03\u8fd4\u56de\u51fa\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)payAbleCallBackRspBo));
        if (!"0000".equals(payAbleCallBackRspBo.getRespCode())) {
            rspBo.setRespCode("213006");
            rspBo.setRespDesc(payAbleCallBackRspBo.getRespDesc());
            return rspBo;
        }
        rspBo.setResult(payAbleCallBackRspBo.getDealResult());
        if (payAbleCallBackRspBo.isAgreementFlag()) {
            String validateAgreementStr = this.validateAgreement(payAbleCallBackRspBo);
            if (!StringUtils.isEmpty((Object)validateAgreementStr)) {
                rspBo.setRespCode("213006");
                rspBo.setRespDesc("able\u8fd4\u56de\u51fa\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateAgreementStr);
                return rspBo;
            }
            if (!this.updateContractInfo(payAbleCallBackRspBo)) {
                this.LOGGER.error("\u66f4\u65b0\u534f\u8bae\u4fe1\u606f\u5931\u8d25");
                rspBo.setRespCode("213006");
                rspBo.setRespDesc("\u66f4\u65b0\u534f\u8bae\u4fe1\u606f\u5931\u8d25");
                return rspBo;
            }
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            this.LOGGER.info("\u7b7e\u7ea6\u56de\u8c03\u5904\u7406\u5b8c\u6210\uff1a" + rspBo);
            return rspBo;
        }
        String validateAbleRspArgStr = this.validateAbleRspArg(payAbleCallBackRspBo);
        if (!StringUtils.isEmpty((Object)validateAbleRspArgStr)) {
            rspBo.setRespCode("213006");
            rspBo.setRespDesc("able\u8fd4\u56de\u51fa\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateAbleRspArgStr);
            return rspBo;
        }
        rspBo.setPayOrderId(payAbleCallBackRspBo.getPayOrderId());
        PayProProcessNotifyBusiReqBo notifyBusiBo = new PayProProcessNotifyBusiReqBo();
        BeanUtils.copyProperties((Object)payAbleCallBackRspBo, (Object)notifyBusiBo);
        notifyBusiBo.setPayMethod(reqBo.getPayMethod());
        PayProProcessNotifyBusiRspBo payProProcessNotifyBusiRspBo = this.payProProcessNotifyBusiService.updateOrder(notifyBusiBo);
        if (!"0000".equals(payProProcessNotifyBusiRspBo.getRespCode())) {
            rspBo.setRespCode("213006");
            rspBo.setRespDesc(payProProcessNotifyBusiRspBo.getRespDesc());
            return rspBo;
        }
        Long orderId = payProProcessNotifyBusiRspBo.getOrderId();
        CallBackNoticeReqBo callBackNoticeReqBo = new CallBackNoticeReqBo();
        callBackNoticeReqBo.setOrderId(orderId);
        callBackNoticeReqBo.setPaymentInsReturnData(payAbleCallBackRspBo.getPaymentInsReturnData());
        CallBackNoticeRspBo callBackNoticeRspBo = this.callBackNoticeService.dealPayPutMq(callBackNoticeReqBo);
        if ("0000".equals(callBackNoticeRspBo.getRspCode())) {
            this.LOGGER.info(orderId + "\u53d1\u9001\u6d88\u606f\u961f\u5217\u6210\u529f");
        } else {
            this.LOGGER.error(orderId + "\u53d1\u9001\u6d88\u606f\u961f\u5217\u5931\u8d25:" + callBackNoticeRspBo.getRspName());
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private boolean updateContractInfo(PayAbleCallBackRspBo payAbleCallBackRspBo) {
        PayInfoContractUpdateBusiRspBo contractUpdateBusiRspBo;
        PayInfoContractUpdateBusiReqBo contractUpdateBusiReqBo = new PayInfoContractUpdateBusiReqBo();
        BeanUtils.copyProperties((Object)payAbleCallBackRspBo, (Object)contractUpdateBusiReqBo);
        if ("NORMAL".equals(payAbleCallBackRspBo.getStatus())) {
            contractUpdateBusiReqBo.setContractStatus(Long.valueOf("1"));
        }
        if (!"0000".equals((contractUpdateBusiRspBo = this.payInfoContractUpdateService.updateContractInfo(contractUpdateBusiReqBo)).getRespCode())) {
            this.LOGGER.error("\u66f4\u65b0\u534f\u8bae\u4fe1\u606f\u8868\u5931\u8d25\uff1a" + contractUpdateBusiRspBo.getRespDesc());
            return false;
        }
        this.LOGGER.info("-------------\u66f4\u65b0\u534f\u8bae\u4fe1\u606f\u8868\u6210\u529f-------------");
        return true;
    }

    private String validateAgreement(PayAbleCallBackRspBo payAbleCallBackRspBo) {
        if (StringUtils.isEmpty((Object)payAbleCallBackRspBo.getContractId())) {
            return "able\u8fd4\u56de\u56de\u8c03\u5904\u7406\u7ed3\u679c\uff0c\u5c5e\u6027'contractId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)payAbleCallBackRspBo.getAgreementNo())) {
            return "able\u8fd4\u56de\u56de\u8c03\u5904\u7406\u7ed3\u679c\uff0c\u5c5e\u6027'agreementNo'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)payAbleCallBackRspBo.getSignTime())) {
            return "able\u8fd4\u56de\u56de\u8c03\u5904\u7406\u7ed3\u679c\uff0c\u5c5e\u6027'signTime'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private String validateAbleRspArg(PayAbleCallBackRspBo reqBo) {
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "able\u8fd4\u56de\u56de\u8c03\u5904\u7406\u7ed3\u679c\uff0c\u5c5e\u6027PayOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayNotifyTransId())) {
            return "able\u8fd4\u56de\u56de\u8c03\u5904\u7406\u7ed3\u679c\uff0c\u5c5e\u6027PayNotifyTransId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getTradeTime())) {
            return "able\u8fd4\u56de\u56de\u8c03\u5904\u7406\u7ed3\u679c\uff0c\u5c5e\u6027TradeTime\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private String validateArg(PayProProcessNoticeCombReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getPayMethod() == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payMethod\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getReqData())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027reqData\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

