/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.bo.PayProBaseRspBo;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.transbo.PayAbleUmcEnterpriseChargeBo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public abstract class AbstractUmcPayAble
implements PayAble {
    private static final Logger log = LoggerFactory.getLogger(AbstractUmcPayAble.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    private static final String UMC_SUCCESS_CODE = "0";
    private static final String UMC_CODE_STR = "code";
    private static final String UMC_MSG_CODE = "message";

    public PayAbleRefundRspBo dealRefund(PayAbleRefundReqBo reqBo) {
        PayAbleRefundRspBo retBo = new PayAbleRefundRspBo();
        String validateStr = this.validateRefundArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("212038");
            retBo.setRespDesc("\u4f1a\u5458\u4f59\u989d\u9000\u6b3e\u65b9\u6cd5\uff0c\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        Map paraMap = reqBo.getParaMap();
        BigDecimal fen = new BigDecimal(reqBo.getRefundFee());
        String yuan = MoneyUtils.fenToYuanToString((BigDecimal)fen);
        PayAbleUmcEnterpriseChargeBo chargeBo = new PayAbleUmcEnterpriseChargeBo();
        chargeBo.setOrgId(Long.parseLong((String)paraMap.get("orgId")));
        chargeBo.setAmount(yuan);
        chargeBo.setOperType("3");
        chargeBo.setPayOrderId(reqBo.getPayOrderId());
        chargeBo.setRefundOrderId(reqBo.getRefundOrderId());
        String resultStr = this.callUmc(chargeBo);
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        this.dealResult((PayProBaseRspBo)retBo, resultStr);
        if ("0000".equals(retBo.getRespCode())) {
            JSONObject jsonObject = JSONObject.parseObject((String)resultStr);
            retBo.setRefundTransId(jsonObject.getJSONObject("data").getLong("logId").toString());
            Date nowTime = this.queryDBDateBusiService.getDBDate();
            retBo.setTradeTime(new DateTime((Object)nowTime).toString("yyyy-MM-ss HH:mm:ss"));
        }
        return retBo;
    }

    public PayAbleCallBackRspBo dealCallBack(PayAbleCallBackReqBo reqBo) {
        return null;
    }

    public PayAbleQryPayStatusRspBo qryPayStatus(PayAbleQryPayStatusReqBo reqBo) {
        PayAbleQryPayStatusRspBo retBo = new PayAbleQryPayStatusRspBo();
        String validateStr = this.validateQryStatusArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("212039");
            retBo.setRespDesc("\u4f1a\u5458\u4f59\u989d\u652f\u4ed8\u72b6\u6001\u67e5\u8be2\u65b9\u6cd5\uff0c\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        Map paraMap = reqBo.getParaMap();
        PayAbleUmcEnterpriseChargeBo chargeBo = new PayAbleUmcEnterpriseChargeBo();
        chargeBo.setOrgId(Long.parseLong((String)paraMap.get("orgId")));
        chargeBo.setOperType("4");
        chargeBo.setPayOrderId(reqBo.getPayOrderId());
        String result = this.callUmc(chargeBo);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        String code = jsonObject.getString(UMC_CODE_STR);
        String message = jsonObject.getString(UMC_MSG_CODE);
        if (!UMC_SUCCESS_CODE.equals(code)) {
            log.error("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a" + message);
            retBo.setRespDesc(message);
            retBo.setRespCode(code);
            return retBo;
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        JSONObject data = jsonObject.getJSONObject("data");
        String sucCode = data.getString("payResult");
        if ("0000".equals(sucCode)) {
            retBo.setPayStatus("SUCCESS");
        } else {
            retBo.setPayStatus("FAIL");
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateQryStatusArgs(PayAbleQryPayStatusReqBo reqBo) {
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e0d\u80fd\u4e3a\u7a7a'";
        }
        if (StringUtils.isEmpty(reqBo.getParaMap().get("orgId"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2d\u7684'orgId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private String validateRefundArgs(PayAbleRefundReqBo reqBo) {
        if (StringUtils.isEmpty((Object)reqBo.getRefundOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'refundOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e0d\u80fd\u4e3a\u7a7a'";
        }
        if (StringUtils.isEmpty(reqBo.getParaMap().get("orgId"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2d\u7684'orgId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    public String callUmc(PayAbleUmcEnterpriseChargeBo chargeBo) {
        String url = this.payPropertiesVo.getValueByKey("umc.balance.url");
        if (StringUtils.isEmpty((Object)url)) {
            log.error("\u4f1a\u5458\u4e2d\u5fc3\u8bf7\u6c42\u5730\u5740(umc.balance.url)\u672a\u914d\u7f6e");
            throw new BusinessException("216035", "\u4f1a\u5458\u4e2d\u5fc3\u8bf7\u6c42\u5730\u5740(umc.balance.url)\u672a\u914d\u7f6e");
        }
        log.info("\u4f1a\u5458\u4e2d\u5fc3\u8bf7\u6c42\u5730\u5740:" + url);
        String accessToken = this.payPropertiesVo.getValueByKey("umc.balance.access.token");
        if (StringUtils.isEmpty((Object)accessToken)) {
            log.error("\u4f1a\u5458\u4e2d\u5fc3\u8bf7\u6c42\u4ee4\u724c(umc.balance.access.token)\u672a\u914d\u7f6e");
            throw new BusinessException("216035", "\u4f1a\u5458\u4e2d\u5fc3\u8bf7\u6c42\u4ee4\u724c(umc.balance.access.token)\u672a\u914d\u7f6e");
        }
        chargeBo.setAccessToken(accessToken);
        String reqDataJsonStr = JSONObject.toJSONString((Object)chargeBo);
        log.info("\u8bf7\u6c42\u4f1a\u5458\u4e2d\u5fc3\u7684\u53c2\u6570\u4e3a\uff1a" + reqDataJsonStr);
        String result = "";
        try {
            result = HttpUtil.post((String)url, (String)reqDataJsonStr);
        }
        catch (Exception e) {
            throw new BusinessException("216035", "\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u6263\u51cf\u63a5\u53e3\u5f02\u5e38");
        }
        log.info("\u4f1a\u5458\u4e2d\u5fc3\u8fd4\u56de\u7684\u53c2\u6570\u4e3a\uff1a" + result);
        return result;
    }

    public void dealResult(PayProBaseRspBo retBo, String resultStr) {
        retBo.setRespCode("8888");
        JSONObject jsonObject = JSONObject.parseObject((String)resultStr);
        String code = jsonObject.getString(UMC_CODE_STR);
        String message = jsonObject.getString(UMC_MSG_CODE);
        if (!UMC_SUCCESS_CODE.equals(code)) {
            log.error("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)message);
            retBo.setRespDesc(message);
            return;
        }
        JSONObject data = jsonObject.getJSONObject("data");
        if (!"0000".equals(data.getString("payResult"))) {
            String errorStr = data.getString("payResultDesc");
            log.error("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5904\u7406\u5931\u8d25\uff1a" + errorStr);
            retBo.setRespDesc(errorStr);
            return;
        }
        if (StringUtils.isEmpty((Object)data.get((Object)"logId"))) {
            log.error("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u63a5\u53e3\u8fd4\u56de\u6d41\u6c34\u53f7\u4e3a\u7a7a");
            retBo.setRespDesc("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u63a5\u53e3\u8fd4\u56de\u6d41\u6c34\u53f7\u4e3a\u7a7a");
            return;
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
    }
}

