/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.ability.PayProOrderAbilityService;
import com.tydic.payment.pay.ability.bo.PayProOrderAbilityServiceReqBo;
import com.tydic.payment.pay.ability.bo.PayProOrderAbilityServiceRspBo;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.atom.PaymentInsAtomService;
import com.tydic.payment.pay.busi.PayProQueryInfoBusiSystemByConditionService;
import com.tydic.payment.pay.busi.bo.PayProQueryInfoBusiSystemByConditionBusiInfoRspBo;
import com.tydic.payment.pay.comb.PayProOrderCombService;
import com.tydic.payment.pay.comb.bo.PayProOrderCombServiceReqBo;
import com.tydic.payment.pay.comb.bo.PayProOrderCombServiceRspBo;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.dao.po.PaymentInsPo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_TEST/2.0.0/com.tydic.payment.pay.ability.PayProOrderAbilityService"})
public class PayProOrderAbilityServiceImpl
implements PayProOrderAbilityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PayProOrderAbilityService.class);
    private static final String SERVICE_NAME = "\u7edf\u4e00\u652f\u4ed8ability\u670d\u52a1";
    @Autowired
    private PayProOrderCombService payProUniPayCombService;
    @Autowired
    private PayProQueryInfoBusiSystemByConditionService queryInfoBusiSystemByConditionService;
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private PaymentInsAtomService paymentInsAtomService;
    @Autowired
    private PayMethodAtomService payMethodAtomService;

    @PostMapping(value={"dealOrder"})
    public PayProOrderAbilityServiceRspBo dealOrder(@RequestBody PayProOrderAbilityServiceReqBo reqBo) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u7edf\u4e00\u652f\u4ed8ability\u670d\u52a1->\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        }
        PayProOrderAbilityServiceRspBo retBo = new PayProOrderAbilityServiceRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("213010");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String busiCode = reqBo.getBusiCode();
        PayProQueryInfoBusiSystemByConditionBusiInfoRspBo busiCodeRspBo = this.queryInfoBusiSystemByConditionService.queryBusiSysByBusiCode(busiCode);
        if (!"0000".equals(busiCodeRspBo.getRespCode())) {
            retBo.setRespCode("214019");
            retBo.setRespDesc("\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u5931\u8d25:" + busiCodeRspBo.getRespDesc());
            return retBo;
        }
        if (!"1".equals(busiCodeRspBo.getState())) {
            retBo.setRespCode("214019");
            retBo.setRespDesc("\u8be5\u4e1a\u52a1\u7cfb\u7edf(" + busiCode + ")\u5df2\u5931\u6548");
            return retBo;
        }
        String merchantId = reqBo.getMerchantId();
        MerChantInfoPo merChantInfo = this.merchantInfoAtomService.queryMerchantInfoById(Long.valueOf(merchantId));
        if (null == merChantInfo) {
            retBo.setRespCode("214019");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u6237[" + merchantId + "]\u7684\u4fe1\u606f");
            return retBo;
        }
        if (!"1".equals(merChantInfo.getFlag())) {
            retBo.setRespCode("214019");
            retBo.setRespDesc("\u5546\u6237[" + merchantId + "]\u672a\u542f\u7528");
            return retBo;
        }
        PayProOrderCombServiceReqBo combReqBo = new PayProOrderCombServiceReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)combReqBo);
        combReqBo.setBusiId(busiCodeRspBo.getBusiId().toString());
        PayProOrderCombServiceRspBo combRetBo = this.payProUniPayCombService.dealOrder(combReqBo);
        if (!"0000".equals(combRetBo.getRespCode())) {
            retBo.setRespCode("214019");
            retBo.setRespDesc(combRetBo.getRespDesc());
            return retBo;
        }
        this.assignment(combRetBo, retBo);
        retBo.setMerchantId(merchantId);
        retBo.setMerchantName(merChantInfo.getMerchantName());
        return retBo;
    }

    private void assignment(PayProOrderCombServiceRspBo combRetBo, PayProOrderAbilityServiceRspBo retBo) {
        BeanUtils.copyProperties((Object)combRetBo, (Object)retBo);
        retBo.setRspCode(combRetBo.getRespCode());
        retBo.setRspName(combRetBo.getRespDesc());
        String payMethod = combRetBo.getPayMethod();
        if (!StringUtils.isEmpty((Object)payMethod)) {
            PayMethodPo methodInfo = this.payMethodAtomService.queryPayMethodById(Long.valueOf(payMethod));
            if (null != methodInfo) {
                retBo.setPayMethod(payMethod);
                retBo.setPayMethodName(methodInfo.getPayMethodName());
            }
            PaymentInsPo paymentInsPo = new PaymentInsPo();
            paymentInsPo.setPaymentInsId(methodInfo.getPaymentInsId());
            List<PaymentInsPo> paymentInsList = this.paymentInsAtomService.queryPaymentInf(paymentInsPo);
            if (!CollectionUtils.isEmpty(paymentInsList)) {
                PaymentInsPo paymentInsInfo = paymentInsList.get(0);
                retBo.setPaymentInsId(paymentInsInfo.getPaymentInsId().toString());
                retBo.setPaymentInsName(paymentInsInfo.getPaymentInsName());
            }
        }
    }

    private String validateArg(PayProOrderAbilityServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiCode())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027busiCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'merchantId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

